package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointSettingsBuilder extends EndpointSettingsFluentImpl<EndpointSettingsBuilder> implements VisitableBuilder<EndpointSettings,EndpointSettingsBuilder>{

    EndpointSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSettingsBuilder(){
            this(true);
    }
    public EndpointSettingsBuilder(Boolean validationEnabled){
            this(new EndpointSettings(), validationEnabled);
    }
    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EndpointSettings(), validationEnabled);
    }
    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent,EndpointSettings instance){
            this(fluent, instance, true);
    }
    public EndpointSettingsBuilder(EndpointSettingsFluent<?> fluent,EndpointSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpointID(instance.getEndpointID()); 
            fluent.withGateway(instance.getGateway()); 
            fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            fluent.withIPAddress(instance.getIPAddress()); 
            fluent.withIPPrefixLen(instance.getIPPrefixLen()); 
            fluent.withIPv6Gateway(instance.getIPv6Gateway()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointSettingsBuilder(EndpointSettings instance){
            this(instance,true);
    }
    public EndpointSettingsBuilder(EndpointSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpointID(instance.getEndpointID()); 
            this.withGateway(instance.getGateway()); 
            this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            this.withIPAddress(instance.getIPAddress()); 
            this.withIPPrefixLen(instance.getIPPrefixLen()); 
            this.withIPv6Gateway(instance.getIPv6Gateway()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableEndpointSettings build(){
            EditableEndpointSettings buildable = new EditableEndpointSettings(fluent.getEndpointID(),fluent.getGateway(),fluent.getGlobalIPv6Address(),fluent.getGlobalIPv6PrefixLen(),fluent.getIPAddress(),fluent.getIPPrefixLen(),fluent.getIPv6Gateway(),fluent.getMacAddress());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointSettingsBuilder that = (EndpointSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
