package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerStateFluent<A extends ContainerStateFluent<A>> extends Fluent<A>{


    public Boolean isDead();
    public A withDead(Boolean Dead);
    public Boolean hasDead();
    public String getError();
    public A withError(String Error);
    public Boolean hasError();
    public Integer getExitCode();
    public A withExitCode(Integer ExitCode);
    public Boolean hasExitCode();
    public String getFinishedAt();
    public A withFinishedAt(String FinishedAt);
    public Boolean hasFinishedAt();
    public Boolean isOOMKilled();
    public A withOOMKilled(Boolean OOMKilled);
    public Boolean hasOOMKilled();
    public Boolean isPaused();
    public A withPaused(Boolean Paused);
    public Boolean hasPaused();
    public Integer getPid();
    public A withPid(Integer Pid);
    public Boolean hasPid();
    public Boolean isRestarting();
    public A withRestarting(Boolean Restarting);
    public Boolean hasRestarting();
    public Boolean isRunning();
    public A withRunning(Boolean Running);
    public Boolean hasRunning();
    public String getStartedAt();
    public A withStartedAt(String StartedAt);
    public Boolean hasStartedAt();
    public String getStatus();
    public A withStatus(String Status);
    public Boolean hasStatus();



}
