package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.docker.api.builder.Predicate;

public interface ContainerProcessListFluent<A extends ContainerProcessListFluent<A>> extends Fluent<A>{


    public A addToProcesses(int index,List<String> item);
    public A setToProcesses(int index,List<String> item);
    public A addToProcesses(List<String>... items);
    public A addAllToProcesses(Collection<List<String>> items);
    public A removeFromProcesses(List<String>... items);
    public A removeAllFromProcesses(Collection<List<String>> items);
    public List<List<String>> getProcesses();
    public List<String> getProcess(int index);
    public List<String> getFirstProcess();
    public List<String> getLastProcess();
    public List<String> getMatchingProcess(io.fabric8.docker.api.builder.Predicate<List<String>> predicate);
    public A withProcesses(List<List<String>> Processes);
    public A withProcesses(List<String>... Processes);
    public Boolean hasProcesses();
    public A addToTitles(int index,String item);
    public A setToTitles(int index,String item);
    public A addToTitles(String... items);
    public A addAllToTitles(Collection<String> items);
    public A removeFromTitles(String... items);
    public A removeAllFromTitles(Collection<String> items);
    public List<String> getTitles();
    public String getTitle(int index);
    public String getFirstTitle();
    public String getLastTitle();
    public String getMatchingTitle(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withTitles(List<String> Titles);
    public A withTitles(String... Titles);
    public Boolean hasTitles();



}
