package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerInspectBuilder extends ContainerInspectFluentImpl<ContainerInspectBuilder> implements VisitableBuilder<ContainerInspect,ContainerInspectBuilder>{

    ContainerInspectFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerInspectBuilder(){
            this(true);
    }
    public ContainerInspectBuilder(Boolean validationEnabled){
            this(new ContainerInspect(), validationEnabled);
    }
    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerInspect(), validationEnabled);
    }
    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent,ContainerInspect instance){
            this(fluent, instance, true);
    }
    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent,ContainerInspect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppArmorProfile(instance.getAppArmorProfile()); 
            fluent.withArgs(instance.getArgs()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withExecDriver(instance.getExecDriver()); 
            fluent.withExecIDs(instance.getExecIDs()); 
            fluent.withGraphDriver(instance.getGraphDriver()); 
            fluent.withHostConfig(instance.getHostConfig()); 
            fluent.withHostnamePath(instance.getHostnamePath()); 
            fluent.withHostsPath(instance.getHostsPath()); 
            fluent.withId(instance.getId()); 
            fluent.withImage(instance.getImage()); 
            fluent.withLogPath(instance.getLogPath()); 
            fluent.withMountLabel(instance.getMountLabel()); 
            fluent.withName(instance.getName()); 
            fluent.withPath(instance.getPath()); 
            fluent.withProcessLabel(instance.getProcessLabel()); 
            fluent.withResolvConfPath(instance.getResolvConfPath()); 
            fluent.withRestartCount(instance.getRestartCount()); 
            fluent.withSizeRootFs(instance.getSizeRootFs()); 
            fluent.withSizeRw(instance.getSizeRw()); 
            fluent.withState(instance.getState()); 
            fluent.withConfig(instance.getConfig()); 
            fluent.withMounts(instance.getMounts()); 
            fluent.withNetworkSettings(instance.getNetworkSettings()); 
            fluent.withConfig(instance.getConfig());

            fluent.withMounts(instance.getMounts());

            fluent.withNetworkSettings(instance.getNetworkSettings());

            this.validationEnabled = validationEnabled; 
    }
    public ContainerInspectBuilder(ContainerInspect instance){
            this(instance,true);
    }
    public ContainerInspectBuilder(ContainerInspect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppArmorProfile(instance.getAppArmorProfile()); 
            this.withArgs(instance.getArgs()); 
            this.withCreated(instance.getCreated()); 
            this.withDriver(instance.getDriver()); 
            this.withExecDriver(instance.getExecDriver()); 
            this.withExecIDs(instance.getExecIDs()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withHostnamePath(instance.getHostnamePath()); 
            this.withHostsPath(instance.getHostsPath()); 
            this.withId(instance.getId()); 
            this.withImage(instance.getImage()); 
            this.withLogPath(instance.getLogPath()); 
            this.withMountLabel(instance.getMountLabel()); 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withProcessLabel(instance.getProcessLabel()); 
            this.withResolvConfPath(instance.getResolvConfPath()); 
            this.withRestartCount(instance.getRestartCount()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withState(instance.getState()); 
            this.withConfig(instance.getConfig()); 
            this.withMounts(instance.getMounts()); 
            this.withNetworkSettings(instance.getNetworkSettings()); 
            this.withConfig(instance.getConfig());

            this.withMounts(instance.getMounts());

            this.withNetworkSettings(instance.getNetworkSettings());

            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerInspect build(){
            EditableContainerInspect buildable = new EditableContainerInspect(fluent.getAppArmorProfile(),fluent.getArgs(),fluent.getCreated(),fluent.getDriver(),fluent.getExecDriver(),fluent.getExecIDs(),fluent.getGraphDriver(),fluent.getHostConfig(),fluent.getHostnamePath(),fluent.getHostsPath(),fluent.getId(),fluent.getImage(),fluent.getLogPath(),fluent.getMountLabel(),fluent.getName(),fluent.getPath(),fluent.getProcessLabel(),fluent.getResolvConfPath(),fluent.getRestartCount(),fluent.getSizeRootFs(),fluent.getSizeRw(),fluent.getState(),fluent.getConfig(),fluent.getMounts(),fluent.getNetworkSettings());
            buildable.setConfig(fluent.getConfig());
            buildable.setMounts(fluent.getMounts());
            buildable.setNetworkSettings(fluent.getNetworkSettings());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerInspectBuilder that = (ContainerInspectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
