package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class BlkioStatsFluentImpl<A extends BlkioStatsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements BlkioStatsFluent<A>{

    private List<BlkioStatEntryBuilder> ioMergedRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioQueueRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServiceBytesRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServiceTimeRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioServicedRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioTimeRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> ioWaitTimeRecursive =  new ArrayList<BlkioStatEntryBuilder>();
    private List<BlkioStatEntryBuilder> sectorsRecursive =  new ArrayList<BlkioStatEntryBuilder>();

    public BlkioStatsFluentImpl(){
    }
    public BlkioStatsFluentImpl(BlkioStats instance){
            this.withIoMergedRecursive(instance.getIoMergedRecursive()); 
            this.withIoQueueRecursive(instance.getIoQueueRecursive()); 
            this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); 
            this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); 
            this.withIoServicedRecursive(instance.getIoServicedRecursive()); 
            this.withIoTimeRecursive(instance.getIoTimeRecursive()); 
            this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); 
            this.withSectorsRecursive(instance.getSectorsRecursive()); 
    }

    public A addToIoMergedRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioMergedRecursive.add(index >= 0 ? index : ioMergedRecursive.size(), builder); return (A)this;
    }

    public A setToIoMergedRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioMergedRecursive.size()) { ioMergedRecursive.add(builder); } else { ioMergedRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoMergedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioMergedRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoMergedRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioMergedRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoMergedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioMergedRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoMergedRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioMergedRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoMergedRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoMergedRecursive(){
            return build(ioMergedRecursive);
    }

    public List<BlkioStatEntry> buildIoMergedRecursive(){
            return build(ioMergedRecursive);
    }

    public BlkioStatEntry buildIoMergedRecursive(int index){
            return this.ioMergedRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoMergedRecursive(){
            return this.ioMergedRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoMergedRecursive(){
            return this.ioMergedRecursive.get(ioMergedRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoMergedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioMergedRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoMergedRecursive(List<BlkioStatEntry> ioMergedRecursive){
            _visitables.removeAll(this.ioMergedRecursive);
            this.ioMergedRecursive.clear();
            if (ioMergedRecursive != null) {for (BlkioStatEntry item : ioMergedRecursive){this.addToIoMergedRecursive(item);}} return (A) this;
    }

    public A withIoMergedRecursive(BlkioStatEntry... ioMergedRecursive){
            this.ioMergedRecursive.clear(); if (ioMergedRecursive != null) {for (BlkioStatEntry item :ioMergedRecursive){ this.addToIoMergedRecursive(item);}} return (A) this;
    }

    public Boolean hasIoMergedRecursive(){
            return ioMergedRecursive!= null && !ioMergedRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursive(){
            return new IoMergedRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursiveLike(BlkioStatEntry item){
            return new IoMergedRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> setNewIoMergedRecursiveLike(int index,BlkioStatEntry item){
            return new IoMergedRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> editIoMergedRecursive(int index){
            if (ioMergedRecursive.size() <= index) throw new RuntimeException("Can't edit ioMergedRecursive. Index exceeds size.");
            return setNewIoMergedRecursiveLike(index, buildIoMergedRecursive(index));
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> editFirstIoMergedRecursive(){
            if (ioMergedRecursive.size() == 0) throw new RuntimeException("Can't edit first ioMergedRecursive. The list is empty.");
            return setNewIoMergedRecursiveLike(0, buildIoMergedRecursive(0));
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> editLastIoMergedRecursive(){
            int index = ioMergedRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioMergedRecursive. The list is empty.");
            return setNewIoMergedRecursiveLike(index, buildIoMergedRecursive(index));
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> editMatchingIoMergedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioMergedRecursive.size();i++) { 
            if (predicate.apply(ioMergedRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioMergedRecursive. No match found.");
            return setNewIoMergedRecursiveLike(index, buildIoMergedRecursive(index));
    }

    public A addNewIoMergedRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoMergedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoQueueRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioQueueRecursive.add(index >= 0 ? index : ioQueueRecursive.size(), builder); return (A)this;
    }

    public A setToIoQueueRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioQueueRecursive.size()) { ioQueueRecursive.add(builder); } else { ioQueueRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoQueueRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioQueueRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoQueueRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioQueueRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoQueueRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioQueueRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoQueueRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioQueueRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoQueueRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoQueueRecursive(){
            return build(ioQueueRecursive);
    }

    public List<BlkioStatEntry> buildIoQueueRecursive(){
            return build(ioQueueRecursive);
    }

    public BlkioStatEntry buildIoQueueRecursive(int index){
            return this.ioQueueRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoQueueRecursive(){
            return this.ioQueueRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoQueueRecursive(){
            return this.ioQueueRecursive.get(ioQueueRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoQueueRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioQueueRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoQueueRecursive(List<BlkioStatEntry> ioQueueRecursive){
            _visitables.removeAll(this.ioQueueRecursive);
            this.ioQueueRecursive.clear();
            if (ioQueueRecursive != null) {for (BlkioStatEntry item : ioQueueRecursive){this.addToIoQueueRecursive(item);}} return (A) this;
    }

    public A withIoQueueRecursive(BlkioStatEntry... ioQueueRecursive){
            this.ioQueueRecursive.clear(); if (ioQueueRecursive != null) {for (BlkioStatEntry item :ioQueueRecursive){ this.addToIoQueueRecursive(item);}} return (A) this;
    }

    public Boolean hasIoQueueRecursive(){
            return ioQueueRecursive!= null && !ioQueueRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursive(){
            return new IoQueueRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursiveLike(BlkioStatEntry item){
            return new IoQueueRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> setNewIoQueueRecursiveLike(int index,BlkioStatEntry item){
            return new IoQueueRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> editIoQueueRecursive(int index){
            if (ioQueueRecursive.size() <= index) throw new RuntimeException("Can't edit ioQueueRecursive. Index exceeds size.");
            return setNewIoQueueRecursiveLike(index, buildIoQueueRecursive(index));
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> editFirstIoQueueRecursive(){
            if (ioQueueRecursive.size() == 0) throw new RuntimeException("Can't edit first ioQueueRecursive. The list is empty.");
            return setNewIoQueueRecursiveLike(0, buildIoQueueRecursive(0));
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> editLastIoQueueRecursive(){
            int index = ioQueueRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioQueueRecursive. The list is empty.");
            return setNewIoQueueRecursiveLike(index, buildIoQueueRecursive(index));
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> editMatchingIoQueueRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioQueueRecursive.size();i++) { 
            if (predicate.apply(ioQueueRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioQueueRecursive. No match found.");
            return setNewIoQueueRecursiveLike(index, buildIoQueueRecursive(index));
    }

    public A addNewIoQueueRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoQueueRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServiceBytesRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioServiceBytesRecursive.add(index >= 0 ? index : ioServiceBytesRecursive.size(), builder); return (A)this;
    }

    public A setToIoServiceBytesRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioServiceBytesRecursive.size()) { ioServiceBytesRecursive.add(builder); } else { ioServiceBytesRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoServiceBytesRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceBytesRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoServiceBytesRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceBytesRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServiceBytesRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceBytesRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoServiceBytesRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceBytesRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoServiceBytesRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServiceBytesRecursive(){
            return build(ioServiceBytesRecursive);
    }

    public List<BlkioStatEntry> buildIoServiceBytesRecursive(){
            return build(ioServiceBytesRecursive);
    }

    public BlkioStatEntry buildIoServiceBytesRecursive(int index){
            return this.ioServiceBytesRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoServiceBytesRecursive(){
            return this.ioServiceBytesRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoServiceBytesRecursive(){
            return this.ioServiceBytesRecursive.get(ioServiceBytesRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoServiceBytesRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioServiceBytesRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoServiceBytesRecursive(List<BlkioStatEntry> ioServiceBytesRecursive){
            _visitables.removeAll(this.ioServiceBytesRecursive);
            this.ioServiceBytesRecursive.clear();
            if (ioServiceBytesRecursive != null) {for (BlkioStatEntry item : ioServiceBytesRecursive){this.addToIoServiceBytesRecursive(item);}} return (A) this;
    }

    public A withIoServiceBytesRecursive(BlkioStatEntry... ioServiceBytesRecursive){
            this.ioServiceBytesRecursive.clear(); if (ioServiceBytesRecursive != null) {for (BlkioStatEntry item :ioServiceBytesRecursive){ this.addToIoServiceBytesRecursive(item);}} return (A) this;
    }

    public Boolean hasIoServiceBytesRecursive(){
            return ioServiceBytesRecursive!= null && !ioServiceBytesRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursive(){
            return new IoServiceBytesRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursiveLike(BlkioStatEntry item){
            return new IoServiceBytesRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> setNewIoServiceBytesRecursiveLike(int index,BlkioStatEntry item){
            return new IoServiceBytesRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editIoServiceBytesRecursive(int index){
            if (ioServiceBytesRecursive.size() <= index) throw new RuntimeException("Can't edit ioServiceBytesRecursive. Index exceeds size.");
            return setNewIoServiceBytesRecursiveLike(index, buildIoServiceBytesRecursive(index));
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editFirstIoServiceBytesRecursive(){
            if (ioServiceBytesRecursive.size() == 0) throw new RuntimeException("Can't edit first ioServiceBytesRecursive. The list is empty.");
            return setNewIoServiceBytesRecursiveLike(0, buildIoServiceBytesRecursive(0));
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editLastIoServiceBytesRecursive(){
            int index = ioServiceBytesRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioServiceBytesRecursive. The list is empty.");
            return setNewIoServiceBytesRecursiveLike(index, buildIoServiceBytesRecursive(index));
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> editMatchingIoServiceBytesRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioServiceBytesRecursive.size();i++) { 
            if (predicate.apply(ioServiceBytesRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioServiceBytesRecursive. No match found.");
            return setNewIoServiceBytesRecursiveLike(index, buildIoServiceBytesRecursive(index));
    }

    public A addNewIoServiceBytesRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServiceBytesRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServiceTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioServiceTimeRecursive.add(index >= 0 ? index : ioServiceTimeRecursive.size(), builder); return (A)this;
    }

    public A setToIoServiceTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioServiceTimeRecursive.size()) { ioServiceTimeRecursive.add(builder); } else { ioServiceTimeRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoServiceTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceTimeRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoServiceTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServiceTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceTimeRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoServiceTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceTimeRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoServiceTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServiceTimeRecursive(){
            return build(ioServiceTimeRecursive);
    }

    public List<BlkioStatEntry> buildIoServiceTimeRecursive(){
            return build(ioServiceTimeRecursive);
    }

    public BlkioStatEntry buildIoServiceTimeRecursive(int index){
            return this.ioServiceTimeRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoServiceTimeRecursive(){
            return this.ioServiceTimeRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoServiceTimeRecursive(){
            return this.ioServiceTimeRecursive.get(ioServiceTimeRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoServiceTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioServiceTimeRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoServiceTimeRecursive(List<BlkioStatEntry> ioServiceTimeRecursive){
            _visitables.removeAll(this.ioServiceTimeRecursive);
            this.ioServiceTimeRecursive.clear();
            if (ioServiceTimeRecursive != null) {for (BlkioStatEntry item : ioServiceTimeRecursive){this.addToIoServiceTimeRecursive(item);}} return (A) this;
    }

    public A withIoServiceTimeRecursive(BlkioStatEntry... ioServiceTimeRecursive){
            this.ioServiceTimeRecursive.clear(); if (ioServiceTimeRecursive != null) {for (BlkioStatEntry item :ioServiceTimeRecursive){ this.addToIoServiceTimeRecursive(item);}} return (A) this;
    }

    public Boolean hasIoServiceTimeRecursive(){
            return ioServiceTimeRecursive!= null && !ioServiceTimeRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursive(){
            return new IoServiceTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursiveLike(BlkioStatEntry item){
            return new IoServiceTimeRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> setNewIoServiceTimeRecursiveLike(int index,BlkioStatEntry item){
            return new IoServiceTimeRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editIoServiceTimeRecursive(int index){
            if (ioServiceTimeRecursive.size() <= index) throw new RuntimeException("Can't edit ioServiceTimeRecursive. Index exceeds size.");
            return setNewIoServiceTimeRecursiveLike(index, buildIoServiceTimeRecursive(index));
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editFirstIoServiceTimeRecursive(){
            if (ioServiceTimeRecursive.size() == 0) throw new RuntimeException("Can't edit first ioServiceTimeRecursive. The list is empty.");
            return setNewIoServiceTimeRecursiveLike(0, buildIoServiceTimeRecursive(0));
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editLastIoServiceTimeRecursive(){
            int index = ioServiceTimeRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioServiceTimeRecursive. The list is empty.");
            return setNewIoServiceTimeRecursiveLike(index, buildIoServiceTimeRecursive(index));
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> editMatchingIoServiceTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioServiceTimeRecursive.size();i++) { 
            if (predicate.apply(ioServiceTimeRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioServiceTimeRecursive. No match found.");
            return setNewIoServiceTimeRecursiveLike(index, buildIoServiceTimeRecursive(index));
    }

    public A addNewIoServiceTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServiceTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServicedRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioServicedRecursive.add(index >= 0 ? index : ioServicedRecursive.size(), builder); return (A)this;
    }

    public A setToIoServicedRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioServicedRecursive.size()) { ioServicedRecursive.add(builder); } else { ioServicedRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoServicedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServicedRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoServicedRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServicedRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServicedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServicedRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoServicedRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServicedRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoServicedRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoServicedRecursive(){
            return build(ioServicedRecursive);
    }

    public List<BlkioStatEntry> buildIoServicedRecursive(){
            return build(ioServicedRecursive);
    }

    public BlkioStatEntry buildIoServicedRecursive(int index){
            return this.ioServicedRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoServicedRecursive(){
            return this.ioServicedRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoServicedRecursive(){
            return this.ioServicedRecursive.get(ioServicedRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoServicedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioServicedRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoServicedRecursive(List<BlkioStatEntry> ioServicedRecursive){
            _visitables.removeAll(this.ioServicedRecursive);
            this.ioServicedRecursive.clear();
            if (ioServicedRecursive != null) {for (BlkioStatEntry item : ioServicedRecursive){this.addToIoServicedRecursive(item);}} return (A) this;
    }

    public A withIoServicedRecursive(BlkioStatEntry... ioServicedRecursive){
            this.ioServicedRecursive.clear(); if (ioServicedRecursive != null) {for (BlkioStatEntry item :ioServicedRecursive){ this.addToIoServicedRecursive(item);}} return (A) this;
    }

    public Boolean hasIoServicedRecursive(){
            return ioServicedRecursive!= null && !ioServicedRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursive(){
            return new IoServicedRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursiveLike(BlkioStatEntry item){
            return new IoServicedRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> setNewIoServicedRecursiveLike(int index,BlkioStatEntry item){
            return new IoServicedRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> editIoServicedRecursive(int index){
            if (ioServicedRecursive.size() <= index) throw new RuntimeException("Can't edit ioServicedRecursive. Index exceeds size.");
            return setNewIoServicedRecursiveLike(index, buildIoServicedRecursive(index));
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> editFirstIoServicedRecursive(){
            if (ioServicedRecursive.size() == 0) throw new RuntimeException("Can't edit first ioServicedRecursive. The list is empty.");
            return setNewIoServicedRecursiveLike(0, buildIoServicedRecursive(0));
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> editLastIoServicedRecursive(){
            int index = ioServicedRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioServicedRecursive. The list is empty.");
            return setNewIoServicedRecursiveLike(index, buildIoServicedRecursive(index));
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> editMatchingIoServicedRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioServicedRecursive.size();i++) { 
            if (predicate.apply(ioServicedRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioServicedRecursive. No match found.");
            return setNewIoServicedRecursiveLike(index, buildIoServicedRecursive(index));
    }

    public A addNewIoServicedRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServicedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioTimeRecursive.add(index >= 0 ? index : ioTimeRecursive.size(), builder); return (A)this;
    }

    public A setToIoTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioTimeRecursive.size()) { ioTimeRecursive.add(builder); } else { ioTimeRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioTimeRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioTimeRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioTimeRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoTimeRecursive(){
            return build(ioTimeRecursive);
    }

    public List<BlkioStatEntry> buildIoTimeRecursive(){
            return build(ioTimeRecursive);
    }

    public BlkioStatEntry buildIoTimeRecursive(int index){
            return this.ioTimeRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoTimeRecursive(){
            return this.ioTimeRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoTimeRecursive(){
            return this.ioTimeRecursive.get(ioTimeRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioTimeRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoTimeRecursive(List<BlkioStatEntry> ioTimeRecursive){
            _visitables.removeAll(this.ioTimeRecursive);
            this.ioTimeRecursive.clear();
            if (ioTimeRecursive != null) {for (BlkioStatEntry item : ioTimeRecursive){this.addToIoTimeRecursive(item);}} return (A) this;
    }

    public A withIoTimeRecursive(BlkioStatEntry... ioTimeRecursive){
            this.ioTimeRecursive.clear(); if (ioTimeRecursive != null) {for (BlkioStatEntry item :ioTimeRecursive){ this.addToIoTimeRecursive(item);}} return (A) this;
    }

    public Boolean hasIoTimeRecursive(){
            return ioTimeRecursive!= null && !ioTimeRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursive(){
            return new IoTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursiveLike(BlkioStatEntry item){
            return new IoTimeRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> setNewIoTimeRecursiveLike(int index,BlkioStatEntry item){
            return new IoTimeRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> editIoTimeRecursive(int index){
            if (ioTimeRecursive.size() <= index) throw new RuntimeException("Can't edit ioTimeRecursive. Index exceeds size.");
            return setNewIoTimeRecursiveLike(index, buildIoTimeRecursive(index));
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> editFirstIoTimeRecursive(){
            if (ioTimeRecursive.size() == 0) throw new RuntimeException("Can't edit first ioTimeRecursive. The list is empty.");
            return setNewIoTimeRecursiveLike(0, buildIoTimeRecursive(0));
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> editLastIoTimeRecursive(){
            int index = ioTimeRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioTimeRecursive. The list is empty.");
            return setNewIoTimeRecursiveLike(index, buildIoTimeRecursive(index));
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> editMatchingIoTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioTimeRecursive.size();i++) { 
            if (predicate.apply(ioTimeRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioTimeRecursive. No match found.");
            return setNewIoTimeRecursiveLike(index, buildIoTimeRecursive(index));
    }

    public A addNewIoTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoWaitTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ioWaitTimeRecursive.add(index >= 0 ? index : ioWaitTimeRecursive.size(), builder); return (A)this;
    }

    public A setToIoWaitTimeRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ioWaitTimeRecursive.size()) { ioWaitTimeRecursive.add(builder); } else { ioWaitTimeRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToIoWaitTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioWaitTimeRecursive.add(builder);} return (A)this;
    }

    public A addAllToIoWaitTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioWaitTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoWaitTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioWaitTimeRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromIoWaitTimeRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioWaitTimeRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIoWaitTimeRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getIoWaitTimeRecursive(){
            return build(ioWaitTimeRecursive);
    }

    public List<BlkioStatEntry> buildIoWaitTimeRecursive(){
            return build(ioWaitTimeRecursive);
    }

    public BlkioStatEntry buildIoWaitTimeRecursive(int index){
            return this.ioWaitTimeRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstIoWaitTimeRecursive(){
            return this.ioWaitTimeRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastIoWaitTimeRecursive(){
            return this.ioWaitTimeRecursive.get(ioWaitTimeRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingIoWaitTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: ioWaitTimeRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIoWaitTimeRecursive(List<BlkioStatEntry> ioWaitTimeRecursive){
            _visitables.removeAll(this.ioWaitTimeRecursive);
            this.ioWaitTimeRecursive.clear();
            if (ioWaitTimeRecursive != null) {for (BlkioStatEntry item : ioWaitTimeRecursive){this.addToIoWaitTimeRecursive(item);}} return (A) this;
    }

    public A withIoWaitTimeRecursive(BlkioStatEntry... ioWaitTimeRecursive){
            this.ioWaitTimeRecursive.clear(); if (ioWaitTimeRecursive != null) {for (BlkioStatEntry item :ioWaitTimeRecursive){ this.addToIoWaitTimeRecursive(item);}} return (A) this;
    }

    public Boolean hasIoWaitTimeRecursive(){
            return ioWaitTimeRecursive!= null && !ioWaitTimeRecursive.isEmpty();
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursive(){
            return new IoWaitTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursiveLike(BlkioStatEntry item){
            return new IoWaitTimeRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> setNewIoWaitTimeRecursiveLike(int index,BlkioStatEntry item){
            return new IoWaitTimeRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editIoWaitTimeRecursive(int index){
            if (ioWaitTimeRecursive.size() <= index) throw new RuntimeException("Can't edit ioWaitTimeRecursive. Index exceeds size.");
            return setNewIoWaitTimeRecursiveLike(index, buildIoWaitTimeRecursive(index));
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editFirstIoWaitTimeRecursive(){
            if (ioWaitTimeRecursive.size() == 0) throw new RuntimeException("Can't edit first ioWaitTimeRecursive. The list is empty.");
            return setNewIoWaitTimeRecursiveLike(0, buildIoWaitTimeRecursive(0));
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editLastIoWaitTimeRecursive(){
            int index = ioWaitTimeRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ioWaitTimeRecursive. The list is empty.");
            return setNewIoWaitTimeRecursiveLike(index, buildIoWaitTimeRecursive(index));
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> editMatchingIoWaitTimeRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<ioWaitTimeRecursive.size();i++) { 
            if (predicate.apply(ioWaitTimeRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ioWaitTimeRecursive. No match found.");
            return setNewIoWaitTimeRecursiveLike(index, buildIoWaitTimeRecursive(index));
    }

    public A addNewIoWaitTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoWaitTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToSectorsRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.sectorsRecursive.add(index >= 0 ? index : sectorsRecursive.size(), builder); return (A)this;
    }

    public A setToSectorsRecursive(int index,BlkioStatEntry item){
            BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= sectorsRecursive.size()) { sectorsRecursive.add(builder); } else { sectorsRecursive.set(index, builder);}
             return (A)this;
    }

    public A addToSectorsRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.sectorsRecursive.add(builder);} return (A)this;
    }

    public A addAllToSectorsRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.sectorsRecursive.add(builder);} return (A)this;
    }

    public A removeFromSectorsRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.sectorsRecursive.remove(builder);} return (A)this;
    }

    public A removeAllFromSectorsRecursive(Collection<BlkioStatEntry> items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.sectorsRecursive.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSectorsRecursive instead.
 */
@Deprecated public List<BlkioStatEntry> getSectorsRecursive(){
            return build(sectorsRecursive);
    }

    public List<BlkioStatEntry> buildSectorsRecursive(){
            return build(sectorsRecursive);
    }

    public BlkioStatEntry buildSectorsRecursive(int index){
            return this.sectorsRecursive.get(index).build();
    }

    public BlkioStatEntry buildFirstSectorsRecursive(){
            return this.sectorsRecursive.get(0).build();
    }

    public BlkioStatEntry buildLastSectorsRecursive(){
            return this.sectorsRecursive.get(sectorsRecursive.size() - 1).build();
    }

    public BlkioStatEntry buildMatchingSectorsRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            for (BlkioStatEntryBuilder item: sectorsRecursive) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withSectorsRecursive(List<BlkioStatEntry> sectorsRecursive){
            _visitables.removeAll(this.sectorsRecursive);
            this.sectorsRecursive.clear();
            if (sectorsRecursive != null) {for (BlkioStatEntry item : sectorsRecursive){this.addToSectorsRecursive(item);}} return (A) this;
    }

    public A withSectorsRecursive(BlkioStatEntry... sectorsRecursive){
            this.sectorsRecursive.clear(); if (sectorsRecursive != null) {for (BlkioStatEntry item :sectorsRecursive){ this.addToSectorsRecursive(item);}} return (A) this;
    }

    public Boolean hasSectorsRecursive(){
            return sectorsRecursive!= null && !sectorsRecursive.isEmpty();
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursive(){
            return new SectorsRecursiveNestedImpl();
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursiveLike(BlkioStatEntry item){
            return new SectorsRecursiveNestedImpl(-1, item);
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> setNewSectorsRecursiveLike(int index,BlkioStatEntry item){
            return new SectorsRecursiveNestedImpl(index, item);
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> editSectorsRecursive(int index){
            if (sectorsRecursive.size() <= index) throw new RuntimeException("Can't edit sectorsRecursive. Index exceeds size.");
            return setNewSectorsRecursiveLike(index, buildSectorsRecursive(index));
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> editFirstSectorsRecursive(){
            if (sectorsRecursive.size() == 0) throw new RuntimeException("Can't edit first sectorsRecursive. The list is empty.");
            return setNewSectorsRecursiveLike(0, buildSectorsRecursive(0));
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> editLastSectorsRecursive(){
            int index = sectorsRecursive.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last sectorsRecursive. The list is empty.");
            return setNewSectorsRecursiveLike(index, buildSectorsRecursive(index));
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> editMatchingSectorsRecursive(io.fabric8.docker.api.builder.Predicate<BlkioStatEntryBuilder> predicate){
            int index = -1;
            for (int i=0;i<sectorsRecursive.size();i++) { 
            if (predicate.apply(sectorsRecursive.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching sectorsRecursive. No match found.");
            return setNewSectorsRecursiveLike(index, buildSectorsRecursive(index));
    }

    public A addNewSectorsRecursive(Long major,Long minor,String op,Long value){
            return (A)addToSectorsRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BlkioStatsFluentImpl that = (BlkioStatsFluentImpl) o;
            if (ioMergedRecursive != null ? !ioMergedRecursive.equals(that.ioMergedRecursive) :that.ioMergedRecursive != null) return false;
            if (ioQueueRecursive != null ? !ioQueueRecursive.equals(that.ioQueueRecursive) :that.ioQueueRecursive != null) return false;
            if (ioServiceBytesRecursive != null ? !ioServiceBytesRecursive.equals(that.ioServiceBytesRecursive) :that.ioServiceBytesRecursive != null) return false;
            if (ioServiceTimeRecursive != null ? !ioServiceTimeRecursive.equals(that.ioServiceTimeRecursive) :that.ioServiceTimeRecursive != null) return false;
            if (ioServicedRecursive != null ? !ioServicedRecursive.equals(that.ioServicedRecursive) :that.ioServicedRecursive != null) return false;
            if (ioTimeRecursive != null ? !ioTimeRecursive.equals(that.ioTimeRecursive) :that.ioTimeRecursive != null) return false;
            if (ioWaitTimeRecursive != null ? !ioWaitTimeRecursive.equals(that.ioWaitTimeRecursive) :that.ioWaitTimeRecursive != null) return false;
            if (sectorsRecursive != null ? !sectorsRecursive.equals(that.sectorsRecursive) :that.sectorsRecursive != null) return false;
            return true;
    }


    public class IoMergedRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoMergedRecursiveNested<N>> implements BlkioStatsFluent.IoMergedRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoMergedRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoMergedRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoMergedRecursive(index, builder.build());
    }
    public N endIoMergedRecursive(){
            return and();
    }

}
    public class IoQueueRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoQueueRecursiveNested<N>> implements BlkioStatsFluent.IoQueueRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoQueueRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoQueueRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoQueueRecursive(index, builder.build());
    }
    public N endIoQueueRecursive(){
            return and();
    }

}
    public class IoServiceBytesRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceBytesRecursiveNested<N>> implements BlkioStatsFluent.IoServiceBytesRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoServiceBytesRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServiceBytesRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoServiceBytesRecursive(index, builder.build());
    }
    public N endIoServiceBytesRecursive(){
            return and();
    }

}
    public class IoServiceTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceTimeRecursiveNested<N>> implements BlkioStatsFluent.IoServiceTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoServiceTimeRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServiceTimeRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoServiceTimeRecursive(index, builder.build());
    }
    public N endIoServiceTimeRecursive(){
            return and();
    }

}
    public class IoServicedRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServicedRecursiveNested<N>> implements BlkioStatsFluent.IoServicedRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoServicedRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServicedRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoServicedRecursive(index, builder.build());
    }
    public N endIoServicedRecursive(){
            return and();
    }

}
    public class IoTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoTimeRecursiveNested<N>> implements BlkioStatsFluent.IoTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoTimeRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoTimeRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoTimeRecursive(index, builder.build());
    }
    public N endIoTimeRecursive(){
            return and();
    }

}
    public class IoWaitTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoWaitTimeRecursiveNested<N>> implements BlkioStatsFluent.IoWaitTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            IoWaitTimeRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoWaitTimeRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToIoWaitTimeRecursive(index, builder.build());
    }
    public N endIoWaitTimeRecursive(){
            return and();
    }

}
    public class SectorsRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.SectorsRecursiveNested<N>> implements BlkioStatsFluent.SectorsRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
        private final int index;
    
            SectorsRecursiveNestedImpl(int index,BlkioStatEntry item){
                    this.index = index;
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            SectorsRecursiveNestedImpl(){
                    this.index = -1;
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.setToSectorsRecursive(index, builder.build());
    }
    public N endSectorsRecursive(){
            return and();
    }

}


}
