package io.fabric8.docker.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AddressFluentImpl<A extends AddressFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements AddressFluent<A>{

    private String Addr;
    private Integer PrefixLen;

    public AddressFluentImpl(){
    }
    public AddressFluentImpl(Address instance){
            this.withAddr(instance.getAddr()); 
            this.withPrefixLen(instance.getPrefixLen()); 
    }

    public String getAddr(){
            return this.Addr;
    }

    public A withAddr(String Addr){
            this.Addr=Addr; return (A) this;
    }

    public Boolean hasAddr(){
            return this.Addr!=null;
    }

    public Integer getPrefixLen(){
            return this.PrefixLen;
    }

    public A withPrefixLen(Integer PrefixLen){
            this.PrefixLen=PrefixLen; return (A) this;
    }

    public Boolean hasPrefixLen(){
            return this.PrefixLen!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AddressFluentImpl that = (AddressFluentImpl) o;
            if (Addr != null ? !Addr.equals(that.Addr) :that.Addr != null) return false;
            if (PrefixLen != null ? !PrefixLen.equals(that.PrefixLen) :that.PrefixLen != null) return false;
            return true;
    }




}
