package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AddressBuilder extends AddressFluentImpl<AddressBuilder> implements VisitableBuilder<Address,AddressBuilder>{

    AddressFluent<?> fluent;
    Boolean validationEnabled;

    public AddressBuilder(){
            this(true);
    }
    public AddressBuilder(Boolean validationEnabled){
            this(new Address(), validationEnabled);
    }
    public AddressBuilder(AddressFluent<?> fluent){
            this(fluent, true);
    }
    public AddressBuilder(AddressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Address(), validationEnabled);
    }
    public AddressBuilder(AddressFluent<?> fluent,Address instance){
            this(fluent, instance, true);
    }
    public AddressBuilder(AddressFluent<?> fluent,Address instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddr(instance.getAddr()); 
            fluent.withPrefixLen(instance.getPrefixLen()); 
            this.validationEnabled = validationEnabled; 
    }
    public AddressBuilder(Address instance){
            this(instance,true);
    }
    public AddressBuilder(Address instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddr(instance.getAddr()); 
            this.withPrefixLen(instance.getPrefixLen()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableAddress build(){
            EditableAddress buildable = new EditableAddress(fluent.getAddr(),fluent.getPrefixLen());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AddressBuilder that = (AddressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
