/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Volume;
import io.fabric8.docker.api.model.VolumeBuilder;
import io.fabric8.docker.api.model.VolumeFluentImpl;
import io.fabric8.docker.api.model.VolumesListResponse;
import io.fabric8.docker.api.model.VolumesListResponseFluent;
import java.util.ArrayList;
import java.util.List;

public class VolumesListResponseFluentImpl<A extends VolumesListResponseFluent<A>>
extends BaseFluent<A>
implements VolumesListResponseFluent<A> {
    private List<VisitableBuilder<? extends Volume, ?>> Volumes = new ArrayList();

    public VolumesListResponseFluentImpl() {
    }

    public VolumesListResponseFluentImpl(VolumesListResponse instance) {
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.Volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.Volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return VolumesListResponseFluentImpl.build(this.Volumes);
    }

    @Override
    public A withVolumes(List<Volume> Volumes) {
        this._visitables.removeAll(this.Volumes);
        this.Volumes.clear();
        if (Volumes != null) {
            for (Volume item : Volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... Volumes) {
        this.Volumes.clear();
        if (Volumes != null) {
            for (Volume item : Volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public VolumesListResponseFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(item);
    }

    @Override
    public A addNewVolume(String Driver, String Mountpoint, String Name) {
        return this.addToVolumes(new Volume(Driver, Mountpoint, Name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumesListResponseFluentImpl that = (VolumesListResponseFluentImpl)o;
        return !(this.Volumes != null ? !this.Volumes.equals(that.Volumes) : that.Volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<VolumesListResponseFluent.VolumesNested<N>>
    implements VolumesListResponseFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;

        VolumesNestedImpl(Volume item) {
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumesListResponseFluentImpl.this.addToVolumes(this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }
}

