/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVolumesListResponse;
import io.fabric8.docker.api.model.VolumesListResponse;
import io.fabric8.docker.api.model.VolumesListResponseFluent;
import io.fabric8.docker.api.model.VolumesListResponseFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumesListResponseBuilder
extends VolumesListResponseFluentImpl<VolumesListResponseBuilder>
implements VisitableBuilder<VolumesListResponse, VolumesListResponseBuilder> {
    VolumesListResponseFluent<?> fluent;
    Boolean validationEnabled;

    public VolumesListResponseBuilder() {
        this(true);
    }

    public VolumesListResponseBuilder(Boolean validationEnabled) {
        this(new VolumesListResponse(), validationEnabled);
    }

    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumesListResponse(), validationEnabled);
    }

    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent, VolumesListResponse instance) {
        this(fluent, instance, true);
    }

    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent, VolumesListResponse instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public VolumesListResponseBuilder(VolumesListResponse instance) {
        this(instance, (Boolean)true);
    }

    public VolumesListResponseBuilder(VolumesListResponse instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableVolumesListResponse build() {
        EditableVolumesListResponse buildable = new EditableVolumesListResponse(this.fluent.getVolumes());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumesListResponseBuilder that = (VolumesListResponseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

