/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVolumeCreateRequest;
import io.fabric8.docker.api.model.VolumeCreateRequest;
import io.fabric8.docker.api.model.VolumeCreateRequestFluent;
import io.fabric8.docker.api.model.VolumeCreateRequestFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeCreateRequestBuilder
extends VolumeCreateRequestFluentImpl<VolumeCreateRequestBuilder>
implements VisitableBuilder<VolumeCreateRequest, VolumeCreateRequestBuilder> {
    VolumeCreateRequestFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeCreateRequestBuilder() {
        this(true);
    }

    public VolumeCreateRequestBuilder(Boolean validationEnabled) {
        this(new VolumeCreateRequest(), validationEnabled);
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeCreateRequest(), validationEnabled);
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent, VolumeCreateRequest instance) {
        this(fluent, instance, true);
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequestFluent<?> fluent, VolumeCreateRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDriver(instance.getDriver());
        fluent.withDriverOpts(instance.getDriverOpts());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequest instance) {
        this(instance, (Boolean)true);
    }

    public VolumeCreateRequestBuilder(VolumeCreateRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDriver(instance.getDriver());
        this.withDriverOpts(instance.getDriverOpts());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableVolumeCreateRequest build() {
        EditableVolumeCreateRequest buildable = new EditableVolumeCreateRequest(this.fluent.getDriver(), this.fluent.getDriverOpts(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeCreateRequestBuilder that = (VolumeCreateRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

