/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVolume;
import io.fabric8.docker.api.model.Volume;
import io.fabric8.docker.api.model.VolumeFluent;
import io.fabric8.docker.api.model.VolumeFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeBuilder
extends VolumeFluentImpl<VolumeBuilder>
implements VisitableBuilder<Volume, VolumeBuilder> {
    VolumeFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeBuilder() {
        this(true);
    }

    public VolumeBuilder(Boolean validationEnabled) {
        this(new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this(fluent, instance, true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDriver(instance.getDriver());
        fluent.withMountpoint(instance.getMountpoint());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeBuilder(Volume instance) {
        this(instance, (Boolean)true);
    }

    public VolumeBuilder(Volume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDriver(instance.getDriver());
        this.withMountpoint(instance.getMountpoint());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableVolume build() {
        EditableVolume buildable = new EditableVolume(this.fluent.getDriver(), this.fluent.getMountpoint(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeBuilder that = (VolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

