/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVersion;
import io.fabric8.docker.api.model.Version;
import io.fabric8.docker.api.model.VersionFluent;
import io.fabric8.docker.api.model.VersionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VersionBuilder
extends VersionFluentImpl<VersionBuilder>
implements VisitableBuilder<Version, VersionBuilder> {
    VersionFluent<?> fluent;
    Boolean validationEnabled;

    public VersionBuilder() {
        this(true);
    }

    public VersionBuilder(Boolean validationEnabled) {
        this(new Version(), validationEnabled);
    }

    public VersionBuilder(VersionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VersionBuilder(VersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Version(), validationEnabled);
    }

    public VersionBuilder(VersionFluent<?> fluent, Version instance) {
        this(fluent, instance, true);
    }

    public VersionBuilder(VersionFluent<?> fluent, Version instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withArch(instance.getArch());
        fluent.withBuildTime(instance.getBuildTime());
        fluent.withExperimental(instance.getExperimental());
        fluent.withGitCommit(instance.getGitCommit());
        fluent.withGoVersion(instance.getGoVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withOs(instance.getOs());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public VersionBuilder(Version instance) {
        this(instance, (Boolean)true);
    }

    public VersionBuilder(Version instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withArch(instance.getArch());
        this.withBuildTime(instance.getBuildTime());
        this.withExperimental(instance.getExperimental());
        this.withGitCommit(instance.getGitCommit());
        this.withGoVersion(instance.getGoVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withOs(instance.getOs());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableVersion build() {
        EditableVersion buildable = new EditableVersion(this.fluent.getApiVersion(), this.fluent.getArch(), this.fluent.getBuildTime(), this.fluent.isExperimental(), this.fluent.getGitCommit(), this.fluent.getGoVersion(), this.fluent.getKernelVersion(), this.fluent.getOs(), this.fluent.getVersion());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionBuilder that = (VersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

