/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableThrottlingData;
import io.fabric8.docker.api.model.ThrottlingData;
import io.fabric8.docker.api.model.ThrottlingDataFluent;
import io.fabric8.docker.api.model.ThrottlingDataFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ThrottlingDataBuilder
extends ThrottlingDataFluentImpl<ThrottlingDataBuilder>
implements VisitableBuilder<ThrottlingData, ThrottlingDataBuilder> {
    ThrottlingDataFluent<?> fluent;
    Boolean validationEnabled;

    public ThrottlingDataBuilder() {
        this(true);
    }

    public ThrottlingDataBuilder(Boolean validationEnabled) {
        this(new ThrottlingData(), validationEnabled);
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ThrottlingData(), validationEnabled);
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent, ThrottlingData instance) {
        this(fluent, instance, true);
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent, ThrottlingData instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPeriods(instance.getPeriods());
        fluent.withThrottledPeriods(instance.getThrottledPeriods());
        fluent.withThrottledTime(instance.getThrottledTime());
        this.validationEnabled = validationEnabled;
    }

    public ThrottlingDataBuilder(ThrottlingData instance) {
        this(instance, (Boolean)true);
    }

    public ThrottlingDataBuilder(ThrottlingData instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPeriods(instance.getPeriods());
        this.withThrottledPeriods(instance.getThrottledPeriods());
        this.withThrottledTime(instance.getThrottledTime());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableThrottlingData build() {
        EditableThrottlingData buildable = new EditableThrottlingData(this.fluent.getPeriods(), this.fluent.getThrottledPeriods(), this.fluent.getThrottledTime());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrottlingDataBuilder that = (ThrottlingDataBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

