/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableStats;
import io.fabric8.docker.api.model.Stats;
import io.fabric8.docker.api.model.StatsFluent;
import io.fabric8.docker.api.model.StatsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatsBuilder
extends StatsFluentImpl<StatsBuilder>
implements VisitableBuilder<Stats, StatsBuilder> {
    StatsFluent<?> fluent;
    Boolean validationEnabled;

    public StatsBuilder() {
        this(true);
    }

    public StatsBuilder(Boolean validationEnabled) {
        this(new Stats(), validationEnabled);
    }

    public StatsBuilder(StatsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatsBuilder(StatsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Stats(), validationEnabled);
    }

    public StatsBuilder(StatsFluent<?> fluent, Stats instance) {
        this(fluent, instance, true);
    }

    public StatsBuilder(StatsFluent<?> fluent, Stats instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBlkioStats(instance.getBlkioStats());
        fluent.withCpuStats(instance.getCpuStats());
        fluent.withMemoryStats(instance.getMemoryStats());
        fluent.withPrecpuStats(instance.getPrecpuStats());
        fluent.withRead(instance.getRead());
        this.validationEnabled = validationEnabled;
    }

    public StatsBuilder(Stats instance) {
        this(instance, (Boolean)true);
    }

    public StatsBuilder(Stats instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBlkioStats(instance.getBlkioStats());
        this.withCpuStats(instance.getCpuStats());
        this.withMemoryStats(instance.getMemoryStats());
        this.withPrecpuStats(instance.getPrecpuStats());
        this.withRead(instance.getRead());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableStats build() {
        EditableStats buildable = new EditableStats(this.fluent.getBlkioStats(), this.fluent.getCpuStats(), this.fluent.getMemoryStats(), this.fluent.getPrecpuStats(), this.fluent.getRead());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatsBuilder that = (StatsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

