/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.IndexInfo;
import io.fabric8.docker.api.model.NetIPNet;
import io.fabric8.docker.api.model.NetIPNetBuilder;
import io.fabric8.docker.api.model.NetIPNetFluentImpl;
import io.fabric8.docker.api.model.ServiceConfig;
import io.fabric8.docker.api.model.ServiceConfigFluent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceConfigFluentImpl<A extends ServiceConfigFluent<A>>
extends BaseFluent<A>
implements ServiceConfigFluent<A> {
    private Map<String, IndexInfo> IndexConfigs = new LinkedHashMap<String, IndexInfo>();
    private List<VisitableBuilder<? extends NetIPNet, ?>> InsecureRegistryCIDRs = new ArrayList();
    private List<String> Mirrors = new ArrayList<String>();

    public ServiceConfigFluentImpl() {
    }

    public ServiceConfigFluentImpl(ServiceConfig instance) {
        this.withIndexConfigs(instance.getIndexConfigs());
        this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        this.withMirrors(instance.getMirrors());
    }

    @Override
    public A addToIndexConfigs(String key, IndexInfo value) {
        if (key != null && value != null) {
            this.IndexConfigs.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToIndexConfigs(Map<String, IndexInfo> map) {
        if (map != null) {
            this.IndexConfigs.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromIndexConfigs(String key) {
        if (key != null) {
            this.IndexConfigs.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromIndexConfigs(Map<String, IndexInfo> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.IndexConfigs.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, IndexInfo> getIndexConfigs() {
        return this.IndexConfigs;
    }

    @Override
    public A withIndexConfigs(Map<String, IndexInfo> IndexConfigs) {
        this.IndexConfigs.clear();
        if (IndexConfigs != null) {
            this.IndexConfigs.putAll(IndexConfigs);
        }
        return (A)this;
    }

    @Override
    public A addToInsecureRegistryCIDRs(NetIPNet ... items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.add(builder);
            this.InsecureRegistryCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInsecureRegistryCIDRs(NetIPNet ... items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.remove(builder);
            this.InsecureRegistryCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NetIPNet> getInsecureRegistryCIDRs() {
        return ServiceConfigFluentImpl.build(this.InsecureRegistryCIDRs);
    }

    @Override
    public A withInsecureRegistryCIDRs(List<NetIPNet> InsecureRegistryCIDRs) {
        this._visitables.removeAll(this.InsecureRegistryCIDRs);
        this.InsecureRegistryCIDRs.clear();
        if (InsecureRegistryCIDRs != null) {
            for (NetIPNet item : InsecureRegistryCIDRs) {
                this.addToInsecureRegistryCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withInsecureRegistryCIDRs(NetIPNet ... InsecureRegistryCIDRs) {
        this.InsecureRegistryCIDRs.clear();
        if (InsecureRegistryCIDRs != null) {
            for (NetIPNet item : InsecureRegistryCIDRs) {
                this.addToInsecureRegistryCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDR() {
        return new InsecureRegistryCIDRsNestedImpl();
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDRLike(NetIPNet item) {
        return new InsecureRegistryCIDRsNestedImpl(item);
    }

    @Override
    public A addNewInsecureRegistryCIDR(String ip, String mask) {
        return this.addToInsecureRegistryCIDRs(new NetIPNet(ip, mask));
    }

    @Override
    public A addNewInsecureRegistryCIDR(String s) {
        return this.addToInsecureRegistryCIDRs(new NetIPNet(s));
    }

    @Override
    public A addToMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMirrors() {
        return this.Mirrors;
    }

    @Override
    public A withMirrors(List<String> Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMirrors(String ... Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceConfigFluentImpl that = (ServiceConfigFluentImpl)o;
        if (this.IndexConfigs != null ? !this.IndexConfigs.equals(that.IndexConfigs) : that.IndexConfigs != null) {
            return false;
        }
        if (this.InsecureRegistryCIDRs != null ? !this.InsecureRegistryCIDRs.equals(that.InsecureRegistryCIDRs) : that.InsecureRegistryCIDRs != null) {
            return false;
        }
        return !(this.Mirrors != null ? !this.Mirrors.equals(that.Mirrors) : that.Mirrors != null);
    }

    public class InsecureRegistryCIDRsNestedImpl<N>
    extends NetIPNetFluentImpl<ServiceConfigFluent.InsecureRegistryCIDRsNested<N>>
    implements ServiceConfigFluent.InsecureRegistryCIDRsNested<N>,
    Nested<N> {
        private final NetIPNetBuilder builder;

        InsecureRegistryCIDRsNestedImpl(NetIPNet item) {
            this.builder = new NetIPNetBuilder(this, item);
        }

        InsecureRegistryCIDRsNestedImpl() {
            this.builder = new NetIPNetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceConfigFluentImpl.this.addToInsecureRegistryCIDRs(this.builder.build());
        }

        @Override
        public N endInsecureRegistryCIDR() {
            return this.and();
        }
    }
}

