/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.SearchResult;
import io.fabric8.docker.api.model.SearchResultBuilder;
import io.fabric8.docker.api.model.SearchResultFluentImpl;
import io.fabric8.docker.api.model.SearchResults;
import io.fabric8.docker.api.model.SearchResultsFluent;
import java.util.ArrayList;
import java.util.List;

public class SearchResultsFluentImpl<A extends SearchResultsFluent<A>>
extends BaseFluent<A>
implements SearchResultsFluent<A> {
    private Integer numResults;
    private String query;
    private List<VisitableBuilder<? extends SearchResult, ?>> results = new ArrayList();

    public SearchResultsFluentImpl() {
    }

    public SearchResultsFluentImpl(SearchResults instance) {
        this.withNumResults(instance.getNumResults());
        this.withQuery(instance.getQuery());
        this.withResults(instance.getResults());
    }

    @Override
    public Integer getNumResults() {
        return this.numResults;
    }

    @Override
    public A withNumResults(Integer numResults) {
        this.numResults = numResults;
        return (A)this;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public A withQuery(String query) {
        this.query = query;
        return (A)this;
    }

    @Override
    public A addToResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.remove(builder);
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<SearchResult> getResults() {
        return SearchResultsFluentImpl.build(this.results);
    }

    @Override
    public A withResults(List<SearchResult> results) {
        this._visitables.removeAll(this.results);
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withResults(SearchResult ... results) {
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public SearchResultsFluent.ResultsNested<A> addNewResultLike(SearchResult item) {
        return new ResultsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultsFluentImpl that = (SearchResultsFluentImpl)o;
        if (this.numResults != null ? !this.numResults.equals(that.numResults) : that.numResults != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        return !(this.results != null ? !this.results.equals(that.results) : that.results != null);
    }

    public class ResultsNestedImpl<N>
    extends SearchResultFluentImpl<SearchResultsFluent.ResultsNested<N>>
    implements SearchResultsFluent.ResultsNested<N>,
    Nested<N> {
        private final SearchResultBuilder builder;

        ResultsNestedImpl(SearchResult item) {
            this.builder = new SearchResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.builder = new SearchResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)SearchResultsFluentImpl.this.addToResults(this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }
}

