/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableSearchResults;
import io.fabric8.docker.api.model.SearchResults;
import io.fabric8.docker.api.model.SearchResultsFluent;
import io.fabric8.docker.api.model.SearchResultsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SearchResultsBuilder
extends SearchResultsFluentImpl<SearchResultsBuilder>
implements VisitableBuilder<SearchResults, SearchResultsBuilder> {
    SearchResultsFluent<?> fluent;
    Boolean validationEnabled;

    public SearchResultsBuilder() {
        this(true);
    }

    public SearchResultsBuilder(Boolean validationEnabled) {
        this(new SearchResults(), validationEnabled);
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SearchResults(), validationEnabled);
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent, SearchResults instance) {
        this(fluent, instance, true);
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent, SearchResults instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNumResults(instance.getNumResults());
        fluent.withQuery(instance.getQuery());
        fluent.withResults(instance.getResults());
        this.validationEnabled = validationEnabled;
    }

    public SearchResultsBuilder(SearchResults instance) {
        this(instance, (Boolean)true);
    }

    public SearchResultsBuilder(SearchResults instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNumResults(instance.getNumResults());
        this.withQuery(instance.getQuery());
        this.withResults(instance.getResults());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableSearchResults build() {
        EditableSearchResults buildable = new EditableSearchResults(this.fluent.getNumResults(), this.fluent.getQuery(), this.fluent.getResults());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultsBuilder that = (SearchResultsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

