/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableSearchResult;
import io.fabric8.docker.api.model.SearchResult;
import io.fabric8.docker.api.model.SearchResultFluent;
import io.fabric8.docker.api.model.SearchResultFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SearchResultBuilder
extends SearchResultFluentImpl<SearchResultBuilder>
implements VisitableBuilder<SearchResult, SearchResultBuilder> {
    SearchResultFluent<?> fluent;
    Boolean validationEnabled;

    public SearchResultBuilder() {
        this(true);
    }

    public SearchResultBuilder(Boolean validationEnabled) {
        this(new SearchResult(), validationEnabled);
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SearchResult(), validationEnabled);
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent, SearchResult instance) {
        this(fluent, instance, true);
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent, SearchResult instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withIsAutomated(instance.getIsAutomated());
        fluent.withIsOfficial(instance.getIsOfficial());
        fluent.withIsTrusted(instance.getIsTrusted());
        fluent.withName(instance.getName());
        fluent.withStarCount(instance.getStarCount());
        this.validationEnabled = validationEnabled;
    }

    public SearchResultBuilder(SearchResult instance) {
        this(instance, (Boolean)true);
    }

    public SearchResultBuilder(SearchResult instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withIsAutomated(instance.getIsAutomated());
        this.withIsOfficial(instance.getIsOfficial());
        this.withIsTrusted(instance.getIsTrusted());
        this.withName(instance.getName());
        this.withStarCount(instance.getStarCount());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableSearchResult build() {
        EditableSearchResult buildable = new EditableSearchResult(this.fluent.getDescription(), this.fluent.isIsAutomated(), this.fluent.isIsOfficial(), this.fluent.isIsTrusted(), this.fluent.getName(), this.fluent.getStarCount());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultBuilder that = (SearchResultBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

