/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditablePortBinding;
import io.fabric8.docker.api.model.PortBinding;
import io.fabric8.docker.api.model.PortBindingFluent;
import io.fabric8.docker.api.model.PortBindingFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PortBindingBuilder
extends PortBindingFluentImpl<PortBindingBuilder>
implements VisitableBuilder<PortBinding, PortBindingBuilder> {
    PortBindingFluent<?> fluent;
    Boolean validationEnabled;

    public PortBindingBuilder() {
        this(true);
    }

    public PortBindingBuilder(Boolean validationEnabled) {
        this(new PortBinding(), validationEnabled);
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PortBinding(), validationEnabled);
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent, PortBinding instance) {
        this(fluent, instance, true);
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent, PortBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostIp(instance.getHostIp());
        fluent.withHostPort(instance.getHostPort());
        this.validationEnabled = validationEnabled;
    }

    public PortBindingBuilder(PortBinding instance) {
        this(instance, (Boolean)true);
    }

    public PortBindingBuilder(PortBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostIp(instance.getHostIp());
        this.withHostPort(instance.getHostPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditablePortBinding build() {
        EditablePortBinding buildable = new EditablePortBinding(this.fluent.getHostIp(), this.fluent.getHostPort());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBindingBuilder that = (PortBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

