/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkSettings;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsFluent;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkSettingsBuilder
extends NetworkSettingsFluentImpl<NetworkSettingsBuilder>
implements VisitableBuilder<NetworkSettings, NetworkSettingsBuilder> {
    NetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBuilder() {
        this(true);
    }

    public NetworkSettingsBuilder(Boolean validationEnabled) {
        this(new NetworkSettings(), validationEnabled);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSettings(), validationEnabled);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, NetworkSettings instance) {
        this(fluent, instance, true);
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, NetworkSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings());
        fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase());
        fluent.withNetworks(instance.getNetworks());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSettingsBuilder(NetworkSettings instance) {
        this(instance, (Boolean)true);
    }

    public NetworkSettingsBuilder(NetworkSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings());
        this.withNetworkSettingsBase(instance.getNetworkSettingsBase());
        this.withNetworks(instance.getNetworks());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetworkSettings build() {
        EditableNetworkSettings buildable = new EditableNetworkSettings(this.fluent.getDefaultNetworkSettings(), this.fluent.getNetworkSettingsBase(), this.fluent.getNetworks());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsBuilder that = (NetworkSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

