/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Address;
import io.fabric8.docker.api.model.AddressBuilder;
import io.fabric8.docker.api.model.AddressFluentImpl;
import io.fabric8.docker.api.model.NetworkSettingsBase;
import io.fabric8.docker.api.model.NetworkSettingsBaseFluent;
import io.fabric8.docker.api.model.PortBinding;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NetworkSettingsBaseFluentImpl<A extends NetworkSettingsBaseFluent<A>>
extends BaseFluent<A>
implements NetworkSettingsBaseFluent<A> {
    private String Bridge;
    private Boolean HairpinMode;
    private String LinkLocalIPv6Address;
    private Integer LinkLocalIPv6PrefixLen;
    private Map<String, ArrayList<PortBinding>> Ports = new LinkedHashMap<String, ArrayList<PortBinding>>();
    private String SandboxID;
    private String SandboxKey;
    private List<VisitableBuilder<? extends Address, ?>> SecondaryIPAddresses = new ArrayList();
    private List<VisitableBuilder<? extends Address, ?>> SecondaryIPv6Addresses = new ArrayList();

    public NetworkSettingsBaseFluentImpl() {
    }

    public NetworkSettingsBaseFluentImpl(NetworkSettingsBase instance) {
        this.withBridge(instance.getBridge());
        this.withHairpinMode(instance.getHairpinMode());
        this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        this.withPorts(instance.getPorts());
        this.withSandboxID(instance.getSandboxID());
        this.withSandboxKey(instance.getSandboxKey());
        this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
    }

    @Override
    public String getBridge() {
        return this.Bridge;
    }

    @Override
    public A withBridge(String Bridge) {
        this.Bridge = Bridge;
        return (A)this;
    }

    @Override
    public Boolean isHairpinMode() {
        return this.HairpinMode;
    }

    @Override
    public A withHairpinMode(Boolean HairpinMode) {
        this.HairpinMode = HairpinMode;
        return (A)this;
    }

    @Override
    public String getLinkLocalIPv6Address() {
        return this.LinkLocalIPv6Address;
    }

    @Override
    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address) {
        this.LinkLocalIPv6Address = LinkLocalIPv6Address;
        return (A)this;
    }

    @Override
    public Integer getLinkLocalIPv6PrefixLen() {
        return this.LinkLocalIPv6PrefixLen;
    }

    @Override
    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen) {
        this.LinkLocalIPv6PrefixLen = LinkLocalIPv6PrefixLen;
        return (A)this;
    }

    @Override
    public A addToPorts(String key, ArrayList<PortBinding> value) {
        if (key != null && value != null) {
            this.Ports.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            this.Ports.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(String key) {
        if (key != null) {
            this.Ports.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Ports.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<PortBinding>> getPorts() {
        return this.Ports;
    }

    @Override
    public A withPorts(Map<String, ArrayList<PortBinding>> Ports) {
        this.Ports.clear();
        if (Ports != null) {
            this.Ports.putAll(Ports);
        }
        return (A)this;
    }

    @Override
    public String getSandboxID() {
        return this.SandboxID;
    }

    @Override
    public A withSandboxID(String SandboxID) {
        this.SandboxID = SandboxID;
        return (A)this;
    }

    @Override
    public String getSandboxKey() {
        return this.SandboxKey;
    }

    @Override
    public A withSandboxKey(String SandboxKey) {
        this.SandboxKey = SandboxKey;
        return (A)this;
    }

    @Override
    public A addToSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Address> getSecondaryIPAddresses() {
        return NetworkSettingsBaseFluentImpl.build(this.SecondaryIPAddresses);
    }

    @Override
    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses) {
        this._visitables.removeAll(this.SecondaryIPAddresses);
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecondaryIPAddresses(Address ... SecondaryIPAddresses) {
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress() {
        return new SecondaryIPAddressesNestedImpl();
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item) {
        return new SecondaryIPAddressesNestedImpl(item);
    }

    @Override
    public A addNewSecondaryIPAddress(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }

    @Override
    public A addToSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPv6Addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPv6Addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Address> getSecondaryIPv6Addresses() {
        return NetworkSettingsBaseFluentImpl.build(this.SecondaryIPv6Addresses);
    }

    @Override
    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses) {
        this._visitables.removeAll(this.SecondaryIPv6Addresses);
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecondaryIPv6Addresses(Address ... SecondaryIPv6Addresses) {
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address() {
        return new SecondaryIPv6AddressesNestedImpl();
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item) {
        return new SecondaryIPv6AddressesNestedImpl(item);
    }

    @Override
    public A addNewSecondaryIPv6Address(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsBaseFluentImpl that = (NetworkSettingsBaseFluentImpl)o;
        if (this.Bridge != null ? !this.Bridge.equals(that.Bridge) : that.Bridge != null) {
            return false;
        }
        if (this.HairpinMode != null ? !this.HairpinMode.equals(that.HairpinMode) : that.HairpinMode != null) {
            return false;
        }
        if (this.LinkLocalIPv6Address != null ? !this.LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) : that.LinkLocalIPv6Address != null) {
            return false;
        }
        if (this.LinkLocalIPv6PrefixLen != null ? !this.LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) : that.LinkLocalIPv6PrefixLen != null) {
            return false;
        }
        if (this.Ports != null ? !this.Ports.equals(that.Ports) : that.Ports != null) {
            return false;
        }
        if (this.SandboxID != null ? !this.SandboxID.equals(that.SandboxID) : that.SandboxID != null) {
            return false;
        }
        if (this.SandboxKey != null ? !this.SandboxKey.equals(that.SandboxKey) : that.SandboxKey != null) {
            return false;
        }
        if (this.SecondaryIPAddresses != null ? !this.SecondaryIPAddresses.equals(that.SecondaryIPAddresses) : that.SecondaryIPAddresses != null) {
            return false;
        }
        return !(this.SecondaryIPv6Addresses != null ? !this.SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) : that.SecondaryIPv6Addresses != null);
    }

    public class SecondaryIPv6AddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>>
    implements NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>,
    Nested<N> {
        private final AddressBuilder builder;

        SecondaryIPv6AddressesNestedImpl(Address item) {
            this.builder = new AddressBuilder(this, item);
        }

        SecondaryIPv6AddressesNestedImpl() {
            this.builder = new AddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSettingsBaseFluentImpl.this.addToSecondaryIPv6Addresses(this.builder.build());
        }

        @Override
        public N endSecondaryIPv6Address() {
            return this.and();
        }
    }

    public class SecondaryIPAddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>>
    implements NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>,
    Nested<N> {
        private final AddressBuilder builder;

        SecondaryIPAddressesNestedImpl(Address item) {
            this.builder = new AddressBuilder(this, item);
        }

        SecondaryIPAddressesNestedImpl() {
            this.builder = new AddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSettingsBaseFluentImpl.this.addToSecondaryIPAddresses(this.builder.build());
        }

        @Override
        public N endSecondaryIPAddress() {
            return this.and();
        }
    }
}

