/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkSettingsBase;
import io.fabric8.docker.api.model.NetworkSettingsBase;
import io.fabric8.docker.api.model.NetworkSettingsBaseFluent;
import io.fabric8.docker.api.model.NetworkSettingsBaseFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkSettingsBaseBuilder
extends NetworkSettingsBaseFluentImpl<NetworkSettingsBaseBuilder>
implements VisitableBuilder<NetworkSettingsBase, NetworkSettingsBaseBuilder> {
    NetworkSettingsBaseFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBaseBuilder() {
        this(true);
    }

    public NetworkSettingsBaseBuilder(Boolean validationEnabled) {
        this(new NetworkSettingsBase(), validationEnabled);
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSettingsBase(), validationEnabled);
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent, NetworkSettingsBase instance) {
        this(fluent, instance, true);
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent, NetworkSettingsBase instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBridge(instance.getBridge());
        fluent.withHairpinMode(instance.getHairpinMode());
        fluent.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        fluent.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        fluent.withPorts(instance.getPorts());
        fluent.withSandboxID(instance.getSandboxID());
        fluent.withSandboxKey(instance.getSandboxKey());
        fluent.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        fluent.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBase instance) {
        this(instance, (Boolean)true);
    }

    public NetworkSettingsBaseBuilder(NetworkSettingsBase instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBridge(instance.getBridge());
        this.withHairpinMode(instance.getHairpinMode());
        this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        this.withPorts(instance.getPorts());
        this.withSandboxID(instance.getSandboxID());
        this.withSandboxKey(instance.getSandboxKey());
        this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetworkSettingsBase build() {
        EditableNetworkSettingsBase buildable = new EditableNetworkSettingsBase(this.fluent.getBridge(), this.fluent.isHairpinMode(), this.fluent.getLinkLocalIPv6Address(), this.fluent.getLinkLocalIPv6PrefixLen(), this.fluent.getPorts(), this.fluent.getSandboxID(), this.fluent.getSandboxKey(), this.fluent.getSecondaryIPAddresses(), this.fluent.getSecondaryIPv6Addresses());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsBaseBuilder that = (NetworkSettingsBaseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

