/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EndpointResource;
import io.fabric8.docker.api.model.IPAM;
import io.fabric8.docker.api.model.IPAMBuilder;
import io.fabric8.docker.api.model.IPAMFluentImpl;
import io.fabric8.docker.api.model.NetworkResource;
import io.fabric8.docker.api.model.NetworkResourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class NetworkResourceFluentImpl<A extends NetworkResourceFluent<A>>
extends BaseFluent<A>
implements NetworkResourceFluent<A> {
    private Map<String, EndpointResource> Containers = new LinkedHashMap<String, EndpointResource>();
    private String Driver;
    private VisitableBuilder<? extends IPAM, ?> IPAM;
    private String Id;
    private String Name;
    private Map<String, String> Options = new LinkedHashMap<String, String>();
    private String Scope;

    public NetworkResourceFluentImpl() {
    }

    public NetworkResourceFluentImpl(NetworkResource instance) {
        this.withContainers(instance.getContainers());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withId(instance.getId());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
        this.withScope(instance.getScope());
    }

    @Override
    public A addToContainers(String key, EndpointResource value) {
        if (key != null && value != null) {
            this.Containers.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Map<String, EndpointResource> map) {
        if (map != null) {
            this.Containers.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(String key) {
        if (key != null) {
            this.Containers.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Map<String, EndpointResource> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Containers.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, EndpointResource> getContainers() {
        return this.Containers;
    }

    @Override
    public A withContainers(Map<String, EndpointResource> Containers) {
        this.Containers.clear();
        if (Containers != null) {
            this.Containers.putAll(Containers);
        }
        return (A)this;
    }

    @Override
    public String getDriver() {
        return this.Driver;
    }

    @Override
    public A withDriver(String Driver) {
        this.Driver = Driver;
        return (A)this;
    }

    @Override
    public IPAM getIPAM() {
        return this.IPAM != null ? (IPAM)this.IPAM.build() : null;
    }

    @Override
    public A withIPAM(IPAM IPAM2) {
        this._visitables.remove(this.IPAM);
        if (IPAM2 != null) {
            this.IPAM = new IPAMBuilder(IPAM2);
            this._visitables.add(this.IPAM);
        }
        return (A)this;
    }

    @Override
    public NetworkResourceFluent.IPAMNested<A> withNewIPAM() {
        return new IPAMNestedImpl();
    }

    @Override
    public NetworkResourceFluent.IPAMNested<A> withNewIPAMLike(IPAM item) {
        return new IPAMNestedImpl(item);
    }

    @Override
    public NetworkResourceFluent.IPAMNested<A> editIPAM() {
        return this.withNewIPAMLike(this.getIPAM());
    }

    @Override
    public NetworkResourceFluent.IPAMNested<A> editOrNewIPAM() {
        return this.withNewIPAMLike(this.getIPAM() != null ? this.getIPAM() : new IPAMBuilder().build());
    }

    @Override
    public NetworkResourceFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item) {
        return this.withNewIPAMLike(this.getIPAM() != null ? this.getIPAM() : item);
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public A withId(String Id) {
        this.Id = Id;
        return (A)this;
    }

    @Override
    public String getName() {
        return this.Name;
    }

    @Override
    public A withName(String Name) {
        this.Name = Name;
        return (A)this;
    }

    @Override
    public A addToOptions(String key, String value) {
        if (key != null && value != null) {
            this.Options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, String> map) {
        if (map != null) {
            this.Options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (key != null) {
            this.Options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.Options;
    }

    @Override
    public A withOptions(Map<String, String> Options) {
        this.Options.clear();
        if (Options != null) {
            this.Options.putAll(Options);
        }
        return (A)this;
    }

    @Override
    public String getScope() {
        return this.Scope;
    }

    @Override
    public A withScope(String Scope) {
        this.Scope = Scope;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkResourceFluentImpl that = (NetworkResourceFluentImpl)o;
        if (this.Containers != null ? !this.Containers.equals(that.Containers) : that.Containers != null) {
            return false;
        }
        if (this.Driver != null ? !this.Driver.equals(that.Driver) : that.Driver != null) {
            return false;
        }
        if (this.IPAM != null ? !this.IPAM.equals(that.IPAM) : that.IPAM != null) {
            return false;
        }
        if (this.Id != null ? !this.Id.equals(that.Id) : that.Id != null) {
            return false;
        }
        if (this.Name != null ? !this.Name.equals(that.Name) : that.Name != null) {
            return false;
        }
        if (this.Options != null ? !this.Options.equals(that.Options) : that.Options != null) {
            return false;
        }
        return !(this.Scope != null ? !this.Scope.equals(that.Scope) : that.Scope != null);
    }

    public class IPAMNestedImpl<N>
    extends IPAMFluentImpl<NetworkResourceFluent.IPAMNested<N>>
    implements NetworkResourceFluent.IPAMNested<N>,
    Nested<N> {
        private final IPAMBuilder builder;

        IPAMNestedImpl(IPAM item) {
            this.builder = new IPAMBuilder(this, item);
        }

        IPAMNestedImpl() {
            this.builder = new IPAMBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkResourceFluentImpl.this.withIPAM(this.builder.build());
        }

        @Override
        public N endIPAM() {
            return this.and();
        }
    }
}

