/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkResource;
import io.fabric8.docker.api.model.NetworkResource;
import io.fabric8.docker.api.model.NetworkResourceFluent;
import io.fabric8.docker.api.model.NetworkResourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkResourceBuilder
extends NetworkResourceFluentImpl<NetworkResourceBuilder>
implements VisitableBuilder<NetworkResource, NetworkResourceBuilder> {
    NetworkResourceFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkResourceBuilder() {
        this(true);
    }

    public NetworkResourceBuilder(Boolean validationEnabled) {
        this(new NetworkResource(), validationEnabled);
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkResource(), validationEnabled);
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent, NetworkResource instance) {
        this(fluent, instance, true);
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent, NetworkResource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainers(instance.getContainers());
        fluent.withDriver(instance.getDriver());
        fluent.withIPAM(instance.getIPAM());
        fluent.withId(instance.getId());
        fluent.withName(instance.getName());
        fluent.withOptions(instance.getOptions());
        fluent.withScope(instance.getScope());
        this.validationEnabled = validationEnabled;
    }

    public NetworkResourceBuilder(NetworkResource instance) {
        this(instance, (Boolean)true);
    }

    public NetworkResourceBuilder(NetworkResource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainers(instance.getContainers());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withId(instance.getId());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
        this.withScope(instance.getScope());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetworkResource build() {
        EditableNetworkResource buildable = new EditableNetworkResource(this.fluent.getContainers(), this.fluent.getDriver(), this.fluent.getIPAM(), this.fluent.getId(), this.fluent.getName(), this.fluent.getOptions(), this.fluent.getScope());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkResourceBuilder that = (NetworkResourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

