/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkCreate;
import io.fabric8.docker.api.model.NetworkCreate;
import io.fabric8.docker.api.model.NetworkCreateFluent;
import io.fabric8.docker.api.model.NetworkCreateFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkCreateBuilder
extends NetworkCreateFluentImpl<NetworkCreateBuilder>
implements VisitableBuilder<NetworkCreate, NetworkCreateBuilder> {
    NetworkCreateFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkCreateBuilder() {
        this(true);
    }

    public NetworkCreateBuilder(Boolean validationEnabled) {
        this(new NetworkCreate(), validationEnabled);
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkCreate(), validationEnabled);
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent, NetworkCreate instance) {
        this(fluent, instance, true);
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent, NetworkCreate instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCheckDuplicate(instance.getCheckDuplicate());
        fluent.withDriver(instance.getDriver());
        fluent.withIPAM(instance.getIPAM());
        fluent.withName(instance.getName());
        fluent.withOptions(instance.getOptions());
        this.validationEnabled = validationEnabled;
    }

    public NetworkCreateBuilder(NetworkCreate instance) {
        this(instance, (Boolean)true);
    }

    public NetworkCreateBuilder(NetworkCreate instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCheckDuplicate(instance.getCheckDuplicate());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetworkCreate build() {
        EditableNetworkCreate buildable = new EditableNetworkCreate(this.fluent.isCheckDuplicate(), this.fluent.getDriver(), this.fluent.getIPAM(), this.fluent.getName(), this.fluent.getOptions());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkCreateBuilder that = (NetworkCreateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

