/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetIPNet;
import io.fabric8.docker.api.model.NetIPNet;
import io.fabric8.docker.api.model.NetIPNetFluent;
import io.fabric8.docker.api.model.NetIPNetFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetIPNetBuilder
extends NetIPNetFluentImpl<NetIPNetBuilder>
implements VisitableBuilder<NetIPNet, NetIPNetBuilder> {
    NetIPNetFluent<?> fluent;
    Boolean validationEnabled;

    public NetIPNetBuilder() {
        this(true);
    }

    public NetIPNetBuilder(Boolean validationEnabled) {
        this(new NetIPNet(), validationEnabled);
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetIPNet(), validationEnabled);
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent, NetIPNet instance) {
        this(fluent, instance, true);
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent, NetIPNet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIp(instance.getIp());
        fluent.withMask(instance.getMask());
        this.validationEnabled = validationEnabled;
    }

    public NetIPNetBuilder(NetIPNet instance) {
        this(instance, (Boolean)true);
    }

    public NetIPNetBuilder(NetIPNet instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIp(instance.getIp());
        this.withMask(instance.getMask());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableNetIPNet build() {
        EditableNetIPNet buildable = new EditableNetIPNet(this.fluent.getIp(), this.fluent.getMask());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetIPNetBuilder that = (NetIPNetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

