/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableMemoryStats;
import io.fabric8.docker.api.model.MemoryStats;
import io.fabric8.docker.api.model.MemoryStatsFluent;
import io.fabric8.docker.api.model.MemoryStatsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MemoryStatsBuilder
extends MemoryStatsFluentImpl<MemoryStatsBuilder>
implements VisitableBuilder<MemoryStats, MemoryStatsBuilder> {
    MemoryStatsFluent<?> fluent;
    Boolean validationEnabled;

    public MemoryStatsBuilder() {
        this(true);
    }

    public MemoryStatsBuilder(Boolean validationEnabled) {
        this(new MemoryStats(), validationEnabled);
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MemoryStats(), validationEnabled);
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent, MemoryStats instance) {
        this(fluent, instance, true);
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent, MemoryStats instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFailcnt(instance.getFailcnt());
        fluent.withLimit(instance.getLimit());
        fluent.withMaxUsage(instance.getMaxUsage());
        fluent.withStats(instance.getStats());
        fluent.withUsage(instance.getUsage());
        this.validationEnabled = validationEnabled;
    }

    public MemoryStatsBuilder(MemoryStats instance) {
        this(instance, (Boolean)true);
    }

    public MemoryStatsBuilder(MemoryStats instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFailcnt(instance.getFailcnt());
        this.withLimit(instance.getLimit());
        this.withMaxUsage(instance.getMaxUsage());
        this.withStats(instance.getStats());
        this.withUsage(instance.getUsage());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableMemoryStats build() {
        EditableMemoryStats buildable = new EditableMemoryStats(this.fluent.getFailcnt(), this.fluent.getLimit(), this.fluent.getMaxUsage(), this.fluent.getStats(), this.fluent.getUsage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemoryStatsBuilder that = (MemoryStatsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

