/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableKeyValuePair;
import io.fabric8.docker.api.model.KeyValuePair;
import io.fabric8.docker.api.model.KeyValuePairFluent;
import io.fabric8.docker.api.model.KeyValuePairFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class KeyValuePairBuilder
extends KeyValuePairFluentImpl<KeyValuePairBuilder>
implements VisitableBuilder<KeyValuePair, KeyValuePairBuilder> {
    KeyValuePairFluent<?> fluent;
    Boolean validationEnabled;

    public KeyValuePairBuilder() {
        this(true);
    }

    public KeyValuePairBuilder(Boolean validationEnabled) {
        this(new KeyValuePair(), validationEnabled);
    }

    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KeyValuePair(), validationEnabled);
    }

    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent, KeyValuePair instance) {
        this(fluent, instance, true);
    }

    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent, KeyValuePair instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public KeyValuePairBuilder(KeyValuePair instance) {
        this(instance, (Boolean)true);
    }

    public KeyValuePairBuilder(KeyValuePair instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableKeyValuePair build() {
        EditableKeyValuePair buildable = new EditableKeyValuePair(this.fluent.getKey(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyValuePairBuilder that = (KeyValuePairBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

