/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableInfo;
import io.fabric8.docker.api.model.Info;
import io.fabric8.docker.api.model.InfoFluent;
import io.fabric8.docker.api.model.InfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class InfoBuilder
extends InfoFluentImpl<InfoBuilder>
implements VisitableBuilder<Info, InfoBuilder> {
    InfoFluent<?> fluent;
    Boolean validationEnabled;

    public InfoBuilder() {
        this(true);
    }

    public InfoBuilder(Boolean validationEnabled) {
        this(new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InfoBuilder(InfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance) {
        this(fluent, instance, true);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBridgeNfIp6tables(instance.getBridgeNfIp6tables());
        fluent.withBridgeNfIptables(instance.getBridgeNfIptables());
        fluent.withClusterAdvertise(instance.getClusterAdvertise());
        fluent.withClusterStore(instance.getClusterStore());
        fluent.withContainers(instance.getContainers());
        fluent.withCpuCfsPeriod(instance.getCpuCfsPeriod());
        fluent.withCpuCfsQuota(instance.getCpuCfsQuota());
        fluent.withDebug(instance.getDebug());
        fluent.withDockerRootDir(instance.getDockerRootDir());
        fluent.withDriver(instance.getDriver());
        fluent.withDriverStatus(instance.getDriverStatus());
        fluent.withExecutionDriver(instance.getExecutionDriver());
        fluent.withExperimentalBuild(instance.getExperimentalBuild());
        fluent.withHttpProxy(instance.getHttpProxy());
        fluent.withHttpsProxy(instance.getHttpsProxy());
        fluent.withID(instance.getID());
        fluent.withIPv4Forwarding(instance.getIPv4Forwarding());
        fluent.withImages(instance.getImages());
        fluent.withIndexServerAddress(instance.getIndexServerAddress());
        fluent.withInitPath(instance.getInitPath());
        fluent.withInitSha1(instance.getInitSha1());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withLabels(instance.getLabels());
        fluent.withLoggingDriver(instance.getLoggingDriver());
        fluent.withMemTotal(instance.getMemTotal());
        fluent.withMemoryLimit(instance.getMemoryLimit());
        fluent.withNCPU(instance.getNCPU());
        fluent.withNEventsListener(instance.getNEventsListener());
        fluent.withNFd(instance.getNFd());
        fluent.withNGoroutines(instance.getNGoroutines());
        fluent.withName(instance.getName());
        fluent.withNoProxy(instance.getNoProxy());
        fluent.withOomKillDisable(instance.getOomKillDisable());
        fluent.withOperatingSystem(instance.getOperatingSystem());
        fluent.withRegistryConfig(instance.getRegistryConfig());
        fluent.withServerVersion(instance.getServerVersion());
        fluent.withSwapLimit(instance.getSwapLimit());
        fluent.withSystemTime(instance.getSystemTime());
        this.validationEnabled = validationEnabled;
    }

    public InfoBuilder(Info instance) {
        this(instance, (Boolean)true);
    }

    public InfoBuilder(Info instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBridgeNfIp6tables(instance.getBridgeNfIp6tables());
        this.withBridgeNfIptables(instance.getBridgeNfIptables());
        this.withClusterAdvertise(instance.getClusterAdvertise());
        this.withClusterStore(instance.getClusterStore());
        this.withContainers(instance.getContainers());
        this.withCpuCfsPeriod(instance.getCpuCfsPeriod());
        this.withCpuCfsQuota(instance.getCpuCfsQuota());
        this.withDebug(instance.getDebug());
        this.withDockerRootDir(instance.getDockerRootDir());
        this.withDriver(instance.getDriver());
        this.withDriverStatus(instance.getDriverStatus());
        this.withExecutionDriver(instance.getExecutionDriver());
        this.withExperimentalBuild(instance.getExperimentalBuild());
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withID(instance.getID());
        this.withIPv4Forwarding(instance.getIPv4Forwarding());
        this.withImages(instance.getImages());
        this.withIndexServerAddress(instance.getIndexServerAddress());
        this.withInitPath(instance.getInitPath());
        this.withInitSha1(instance.getInitSha1());
        this.withKernelVersion(instance.getKernelVersion());
        this.withLabels(instance.getLabels());
        this.withLoggingDriver(instance.getLoggingDriver());
        this.withMemTotal(instance.getMemTotal());
        this.withMemoryLimit(instance.getMemoryLimit());
        this.withNCPU(instance.getNCPU());
        this.withNEventsListener(instance.getNEventsListener());
        this.withNFd(instance.getNFd());
        this.withNGoroutines(instance.getNGoroutines());
        this.withName(instance.getName());
        this.withNoProxy(instance.getNoProxy());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withOperatingSystem(instance.getOperatingSystem());
        this.withRegistryConfig(instance.getRegistryConfig());
        this.withServerVersion(instance.getServerVersion());
        this.withSwapLimit(instance.getSwapLimit());
        this.withSystemTime(instance.getSystemTime());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableInfo build() {
        EditableInfo buildable = new EditableInfo(this.fluent.isBridgeNfIp6tables(), this.fluent.isBridgeNfIptables(), this.fluent.getClusterAdvertise(), this.fluent.getClusterStore(), this.fluent.getContainers(), this.fluent.isCpuCfsPeriod(), this.fluent.isCpuCfsQuota(), this.fluent.isDebug(), this.fluent.getDockerRootDir(), this.fluent.getDriver(), this.fluent.getDriverStatus(), this.fluent.getExecutionDriver(), this.fluent.isExperimentalBuild(), this.fluent.getHttpProxy(), this.fluent.getHttpsProxy(), this.fluent.getID(), this.fluent.isIPv4Forwarding(), this.fluent.getImages(), this.fluent.getIndexServerAddress(), this.fluent.getInitPath(), this.fluent.getInitSha1(), this.fluent.getKernelVersion(), this.fluent.getLabels(), this.fluent.getLoggingDriver(), this.fluent.getMemTotal(), this.fluent.isMemoryLimit(), this.fluent.getNCPU(), this.fluent.getNEventsListener(), this.fluent.getNFd(), this.fluent.getNGoroutines(), this.fluent.getName(), this.fluent.getNoProxy(), this.fluent.isOomKillDisable(), this.fluent.getOperatingSystem(), this.fluent.getRegistryConfig(), this.fluent.getServerVersion(), this.fluent.isSwapLimit(), this.fluent.getSystemTime());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoBuilder that = (InfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

