/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIndexInfo;
import io.fabric8.docker.api.model.IndexInfo;
import io.fabric8.docker.api.model.IndexInfoFluent;
import io.fabric8.docker.api.model.IndexInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IndexInfoBuilder
extends IndexInfoFluentImpl<IndexInfoBuilder>
implements VisitableBuilder<IndexInfo, IndexInfoBuilder> {
    IndexInfoFluent<?> fluent;
    Boolean validationEnabled;

    public IndexInfoBuilder() {
        this(true);
    }

    public IndexInfoBuilder(Boolean validationEnabled) {
        this(new IndexInfo(), validationEnabled);
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IndexInfo(), validationEnabled);
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent, IndexInfo instance) {
        this(fluent, instance, true);
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent, IndexInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMirrors(instance.getMirrors());
        fluent.withName(instance.getName());
        fluent.withOfficial(instance.getOfficial());
        fluent.withSecure(instance.getSecure());
        this.validationEnabled = validationEnabled;
    }

    public IndexInfoBuilder(IndexInfo instance) {
        this(instance, (Boolean)true);
    }

    public IndexInfoBuilder(IndexInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMirrors(instance.getMirrors());
        this.withName(instance.getName());
        this.withOfficial(instance.getOfficial());
        this.withSecure(instance.getSecure());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableIndexInfo build() {
        EditableIndexInfo buildable = new EditableIndexInfo(this.fluent.getMirrors(), this.fluent.getName(), this.fluent.isOfficial(), this.fluent.isSecure());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexInfoBuilder that = (IndexInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

