/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageHistory;
import io.fabric8.docker.api.model.ImageHistory;
import io.fabric8.docker.api.model.ImageHistoryFluent;
import io.fabric8.docker.api.model.ImageHistoryFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageHistoryBuilder
extends ImageHistoryFluentImpl<ImageHistoryBuilder>
implements VisitableBuilder<ImageHistory, ImageHistoryBuilder> {
    ImageHistoryFluent<?> fluent;
    Boolean validationEnabled;

    public ImageHistoryBuilder() {
        this(true);
    }

    public ImageHistoryBuilder(Boolean validationEnabled) {
        this(new ImageHistory(), validationEnabled);
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageHistory(), validationEnabled);
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent, ImageHistory instance) {
        this(fluent, instance, true);
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent, ImageHistory instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withComment(instance.getComment());
        fluent.withCreated(instance.getCreated());
        fluent.withCreatedBy(instance.getCreatedBy());
        fluent.withId(instance.getId());
        fluent.withSize(instance.getSize());
        fluent.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    public ImageHistoryBuilder(ImageHistory instance) {
        this(instance, (Boolean)true);
    }

    public ImageHistoryBuilder(ImageHistory instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withComment(instance.getComment());
        this.withCreated(instance.getCreated());
        this.withCreatedBy(instance.getCreatedBy());
        this.withId(instance.getId());
        this.withSize(instance.getSize());
        this.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableImageHistory build() {
        EditableImageHistory buildable = new EditableImageHistory(this.fluent.getComment(), this.fluent.getCreated(), this.fluent.getCreatedBy(), this.fluent.getId(), this.fluent.getSize(), this.fluent.getTags());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageHistoryBuilder that = (ImageHistoryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

