/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageDelete;
import io.fabric8.docker.api.model.ImageDelete;
import io.fabric8.docker.api.model.ImageDeleteFluent;
import io.fabric8.docker.api.model.ImageDeleteFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageDeleteBuilder
extends ImageDeleteFluentImpl<ImageDeleteBuilder>
implements VisitableBuilder<ImageDelete, ImageDeleteBuilder> {
    ImageDeleteFluent<?> fluent;
    Boolean validationEnabled;

    public ImageDeleteBuilder() {
        this(true);
    }

    public ImageDeleteBuilder(Boolean validationEnabled) {
        this(new ImageDelete(), validationEnabled);
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageDelete(), validationEnabled);
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent, ImageDelete instance) {
        this(fluent, instance, true);
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent, ImageDelete instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDeleted(instance.getDeleted());
        fluent.withUntagged(instance.getUntagged());
        this.validationEnabled = validationEnabled;
    }

    public ImageDeleteBuilder(ImageDelete instance) {
        this(instance, (Boolean)true);
    }

    public ImageDeleteBuilder(ImageDelete instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDeleted(instance.getDeleted());
        this.withUntagged(instance.getUntagged());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableImageDelete build() {
        EditableImageDelete buildable = new EditableImageDelete(this.fluent.getDeleted(), this.fluent.getUntagged());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageDeleteBuilder that = (ImageDeleteBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

