/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.DeviceMapping;
import io.fabric8.docker.api.model.DeviceMappingBuilder;
import io.fabric8.docker.api.model.DeviceMappingFluentImpl;
import io.fabric8.docker.api.model.HostConfig;
import io.fabric8.docker.api.model.HostConfigFluent;
import io.fabric8.docker.api.model.LogConfig;
import io.fabric8.docker.api.model.LogConfigBuilder;
import io.fabric8.docker.api.model.LogConfigFluentImpl;
import io.fabric8.docker.api.model.LxcConfig;
import io.fabric8.docker.api.model.PortBinding;
import io.fabric8.docker.api.model.RestartPolicy;
import io.fabric8.docker.api.model.RestartPolicyBuilder;
import io.fabric8.docker.api.model.RestartPolicyFluentImpl;
import io.fabric8.docker.api.model.Ulimit;
import io.fabric8.docker.api.model.UlimitBuilder;
import io.fabric8.docker.api.model.UlimitFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HostConfigFluentImpl<A extends HostConfigFluent<A>>
extends BaseFluent<A>
implements HostConfigFluent<A> {
    private List<String> Binds = new ArrayList<String>();
    private Integer BlkioWeight;
    private List<String> CapAdd = new ArrayList<String>();
    private List<String> CapDrop = new ArrayList<String>();
    private String CgroupParent;
    private Object ConsoleSize;
    private String ContainerIDFile;
    private Long CpuPeriod;
    private Long CpuQuota;
    private Long CpuShares;
    private String CpusetCpus;
    private String CpusetMems;
    private List<VisitableBuilder<? extends DeviceMapping, ?>> Devices = new ArrayList();
    private List<String> Dns = new ArrayList<String>();
    private List<String> DnsOptions = new ArrayList<String>();
    private List<String> DnsSearch = new ArrayList<String>();
    private List<String> ExtraHosts = new ArrayList<String>();
    private List<String> GroupAdd = new ArrayList<String>();
    private String IpcMode;
    private Long KernelMemory;
    private List<String> Links = new ArrayList<String>();
    private VisitableBuilder<? extends LogConfig, ?> LogConfig;
    private LxcConfig LxcConf;
    private Long Memory;
    private Long MemoryReservation;
    private Long MemorySwap;
    private Long MemorySwappiness;
    private String NetworkMode;
    private Boolean OomKillDisable;
    private String PidMode;
    private Map<String, ArrayList<PortBinding>> PortBindings = new LinkedHashMap<String, ArrayList<PortBinding>>();
    private Boolean Privileged;
    private Boolean PublishAllPorts;
    private Boolean ReadonlyRootfs;
    private VisitableBuilder<? extends RestartPolicy, ?> RestartPolicy;
    private List<String> SecurityOpt = new ArrayList<String>();
    private String UTSMode;
    private List<VisitableBuilder<? extends Ulimit, ?>> Ulimits = new ArrayList();
    private String VolumeDriver;
    private List<String> VolumesFrom = new ArrayList<String>();

    public HostConfigFluentImpl() {
    }

    public HostConfigFluentImpl(HostConfig instance) {
        this.withBinds(instance.getBinds());
        this.withBlkioWeight(instance.getBlkioWeight());
        this.withCapAdd(instance.getCapAdd());
        this.withCapDrop(instance.getCapDrop());
        this.withCgroupParent(instance.getCgroupParent());
        this.withConsoleSize(instance.getConsoleSize());
        this.withContainerIDFile(instance.getContainerIDFile());
        this.withCpuPeriod(instance.getCpuPeriod());
        this.withCpuQuota(instance.getCpuQuota());
        this.withCpuShares(instance.getCpuShares());
        this.withCpusetCpus(instance.getCpusetCpus());
        this.withCpusetMems(instance.getCpusetMems());
        this.withDevices(instance.getDevices());
        this.withDns(instance.getDns());
        this.withDnsOptions(instance.getDnsOptions());
        this.withDnsSearch(instance.getDnsSearch());
        this.withExtraHosts(instance.getExtraHosts());
        this.withGroupAdd(instance.getGroupAdd());
        this.withIpcMode(instance.getIpcMode());
        this.withKernelMemory(instance.getKernelMemory());
        this.withLinks(instance.getLinks());
        this.withLogConfig(instance.getLogConfig());
        this.withLxcConf(instance.getLxcConf());
        this.withMemory(instance.getMemory());
        this.withMemoryReservation(instance.getMemoryReservation());
        this.withMemorySwap(instance.getMemorySwap());
        this.withMemorySwappiness(instance.getMemorySwappiness());
        this.withNetworkMode(instance.getNetworkMode());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withPidMode(instance.getPidMode());
        this.withPortBindings(instance.getPortBindings());
        this.withPrivileged(instance.getPrivileged());
        this.withPublishAllPorts(instance.getPublishAllPorts());
        this.withReadonlyRootfs(instance.getReadonlyRootfs());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSecurityOpt(instance.getSecurityOpt());
        this.withUTSMode(instance.getUTSMode());
        this.withUlimits(instance.getUlimits());
        this.withVolumeDriver(instance.getVolumeDriver());
        this.withVolumesFrom(instance.getVolumesFrom());
    }

    @Override
    public A addToBinds(String ... items) {
        for (String item : items) {
            this.Binds.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBinds(String ... items) {
        for (String item : items) {
            this.Binds.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBinds() {
        return this.Binds;
    }

    @Override
    public A withBinds(List<String> Binds) {
        this.Binds.clear();
        if (Binds != null) {
            for (String item : Binds) {
                this.addToBinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withBinds(String ... Binds) {
        this.Binds.clear();
        if (Binds != null) {
            for (String item : Binds) {
                this.addToBinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Integer getBlkioWeight() {
        return this.BlkioWeight;
    }

    @Override
    public A withBlkioWeight(Integer BlkioWeight) {
        this.BlkioWeight = BlkioWeight;
        return (A)this;
    }

    @Override
    public A addToCapAdd(String ... items) {
        for (String item : items) {
            this.CapAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapAdd(String ... items) {
        for (String item : items) {
            this.CapAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCapAdd() {
        return this.CapAdd;
    }

    @Override
    public A withCapAdd(List<String> CapAdd) {
        this.CapAdd.clear();
        if (CapAdd != null) {
            for (String item : CapAdd) {
                this.addToCapAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCapAdd(String ... CapAdd) {
        this.CapAdd.clear();
        if (CapAdd != null) {
            for (String item : CapAdd) {
                this.addToCapAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToCapDrop(String ... items) {
        for (String item : items) {
            this.CapDrop.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapDrop(String ... items) {
        for (String item : items) {
            this.CapDrop.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCapDrop() {
        return this.CapDrop;
    }

    @Override
    public A withCapDrop(List<String> CapDrop) {
        this.CapDrop.clear();
        if (CapDrop != null) {
            for (String item : CapDrop) {
                this.addToCapDrop(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCapDrop(String ... CapDrop) {
        this.CapDrop.clear();
        if (CapDrop != null) {
            for (String item : CapDrop) {
                this.addToCapDrop(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getCgroupParent() {
        return this.CgroupParent;
    }

    @Override
    public A withCgroupParent(String CgroupParent) {
        this.CgroupParent = CgroupParent;
        return (A)this;
    }

    @Override
    public Object getConsoleSize() {
        return this.ConsoleSize;
    }

    @Override
    public A withConsoleSize(Object ConsoleSize) {
        this.ConsoleSize = ConsoleSize;
        return (A)this;
    }

    @Override
    public String getContainerIDFile() {
        return this.ContainerIDFile;
    }

    @Override
    public A withContainerIDFile(String ContainerIDFile) {
        this.ContainerIDFile = ContainerIDFile;
        return (A)this;
    }

    @Override
    public Long getCpuPeriod() {
        return this.CpuPeriod;
    }

    @Override
    public A withCpuPeriod(Long CpuPeriod) {
        this.CpuPeriod = CpuPeriod;
        return (A)this;
    }

    @Override
    public Long getCpuQuota() {
        return this.CpuQuota;
    }

    @Override
    public A withCpuQuota(Long CpuQuota) {
        this.CpuQuota = CpuQuota;
        return (A)this;
    }

    @Override
    public Long getCpuShares() {
        return this.CpuShares;
    }

    @Override
    public A withCpuShares(Long CpuShares) {
        this.CpuShares = CpuShares;
        return (A)this;
    }

    @Override
    public String getCpusetCpus() {
        return this.CpusetCpus;
    }

    @Override
    public A withCpusetCpus(String CpusetCpus) {
        this.CpusetCpus = CpusetCpus;
        return (A)this;
    }

    @Override
    public String getCpusetMems() {
        return this.CpusetMems;
    }

    @Override
    public A withCpusetMems(String CpusetMems) {
        this.CpusetMems = CpusetMems;
        return (A)this;
    }

    @Override
    public A addToDevices(DeviceMapping ... items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.add(builder);
            this.Devices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDevices(DeviceMapping ... items) {
        for (DeviceMapping item : items) {
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            this._visitables.remove(builder);
            this.Devices.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<DeviceMapping> getDevices() {
        return HostConfigFluentImpl.build(this.Devices);
    }

    @Override
    public A withDevices(List<DeviceMapping> Devices) {
        this._visitables.removeAll(this.Devices);
        this.Devices.clear();
        if (Devices != null) {
            for (DeviceMapping item : Devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDevices(DeviceMapping ... Devices) {
        this.Devices.clear();
        if (Devices != null) {
            for (DeviceMapping item : Devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public HostConfigFluent.DevicesNested<A> addNewDevice() {
        return new DevicesNestedImpl();
    }

    @Override
    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item) {
        return new DevicesNestedImpl(item);
    }

    @Override
    public A addNewDevice(String CgroupPermissions, String PathInContainer, String PathOnHost) {
        return this.addToDevices(new DeviceMapping(CgroupPermissions, PathInContainer, PathOnHost));
    }

    @Override
    public A addToDns(String ... items) {
        for (String item : items) {
            this.Dns.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDns(String ... items) {
        for (String item : items) {
            this.Dns.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDns() {
        return this.Dns;
    }

    @Override
    public A withDns(List<String> Dns) {
        this.Dns.clear();
        if (Dns != null) {
            for (String item : Dns) {
                this.addToDns(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDns(String ... Dns) {
        this.Dns.clear();
        if (Dns != null) {
            for (String item : Dns) {
                this.addToDns(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToDnsOptions(String ... items) {
        for (String item : items) {
            this.DnsOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsOptions(String ... items) {
        for (String item : items) {
            this.DnsOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsOptions() {
        return this.DnsOptions;
    }

    @Override
    public A withDnsOptions(List<String> DnsOptions) {
        this.DnsOptions.clear();
        if (DnsOptions != null) {
            for (String item : DnsOptions) {
                this.addToDnsOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDnsOptions(String ... DnsOptions) {
        this.DnsOptions.clear();
        if (DnsOptions != null) {
            for (String item : DnsOptions) {
                this.addToDnsOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToDnsSearch(String ... items) {
        for (String item : items) {
            this.DnsSearch.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsSearch(String ... items) {
        for (String item : items) {
            this.DnsSearch.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsSearch() {
        return this.DnsSearch;
    }

    @Override
    public A withDnsSearch(List<String> DnsSearch) {
        this.DnsSearch.clear();
        if (DnsSearch != null) {
            for (String item : DnsSearch) {
                this.addToDnsSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDnsSearch(String ... DnsSearch) {
        this.DnsSearch.clear();
        if (DnsSearch != null) {
            for (String item : DnsSearch) {
                this.addToDnsSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToExtraHosts(String ... items) {
        for (String item : items) {
            this.ExtraHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtraHosts(String ... items) {
        for (String item : items) {
            this.ExtraHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExtraHosts() {
        return this.ExtraHosts;
    }

    @Override
    public A withExtraHosts(List<String> ExtraHosts) {
        this.ExtraHosts.clear();
        if (ExtraHosts != null) {
            for (String item : ExtraHosts) {
                this.addToExtraHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtraHosts(String ... ExtraHosts) {
        this.ExtraHosts.clear();
        if (ExtraHosts != null) {
            for (String item : ExtraHosts) {
                this.addToExtraHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToGroupAdd(String ... items) {
        for (String item : items) {
            this.GroupAdd.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupAdd(String ... items) {
        for (String item : items) {
            this.GroupAdd.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupAdd() {
        return this.GroupAdd;
    }

    @Override
    public A withGroupAdd(List<String> GroupAdd) {
        this.GroupAdd.clear();
        if (GroupAdd != null) {
            for (String item : GroupAdd) {
                this.addToGroupAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroupAdd(String ... GroupAdd) {
        this.GroupAdd.clear();
        if (GroupAdd != null) {
            for (String item : GroupAdd) {
                this.addToGroupAdd(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getIpcMode() {
        return this.IpcMode;
    }

    @Override
    public A withIpcMode(String IpcMode) {
        this.IpcMode = IpcMode;
        return (A)this;
    }

    @Override
    public Long getKernelMemory() {
        return this.KernelMemory;
    }

    @Override
    public A withKernelMemory(Long KernelMemory) {
        this.KernelMemory = KernelMemory;
        return (A)this;
    }

    @Override
    public A addToLinks(String ... items) {
        for (String item : items) {
            this.Links.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(String ... items) {
        for (String item : items) {
            this.Links.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLinks() {
        return this.Links;
    }

    @Override
    public A withLinks(List<String> Links) {
        this.Links.clear();
        if (Links != null) {
            for (String item : Links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withLinks(String ... Links) {
        this.Links.clear();
        if (Links != null) {
            for (String item : Links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public LogConfig getLogConfig() {
        return this.LogConfig != null ? (LogConfig)this.LogConfig.build() : null;
    }

    @Override
    public A withLogConfig(LogConfig LogConfig2) {
        this._visitables.remove(this.LogConfig);
        if (LogConfig2 != null) {
            this.LogConfig = new LogConfigBuilder(LogConfig2);
            this._visitables.add(this.LogConfig);
        }
        return (A)this;
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> withNewLogConfig() {
        return new LogConfigNestedImpl();
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item) {
        return new LogConfigNestedImpl(item);
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editLogConfig() {
        return this.withNewLogConfigLike(this.getLogConfig());
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig() {
        return this.withNewLogConfigLike(this.getLogConfig() != null ? this.getLogConfig() : new LogConfigBuilder().build());
    }

    @Override
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item) {
        return this.withNewLogConfigLike(this.getLogConfig() != null ? this.getLogConfig() : item);
    }

    @Override
    public LxcConfig getLxcConf() {
        return this.LxcConf;
    }

    @Override
    public A withLxcConf(LxcConfig LxcConf) {
        this.LxcConf = LxcConf;
        return (A)this;
    }

    @Override
    public Long getMemory() {
        return this.Memory;
    }

    @Override
    public A withMemory(Long Memory) {
        this.Memory = Memory;
        return (A)this;
    }

    @Override
    public Long getMemoryReservation() {
        return this.MemoryReservation;
    }

    @Override
    public A withMemoryReservation(Long MemoryReservation) {
        this.MemoryReservation = MemoryReservation;
        return (A)this;
    }

    @Override
    public Long getMemorySwap() {
        return this.MemorySwap;
    }

    @Override
    public A withMemorySwap(Long MemorySwap) {
        this.MemorySwap = MemorySwap;
        return (A)this;
    }

    @Override
    public Long getMemorySwappiness() {
        return this.MemorySwappiness;
    }

    @Override
    public A withMemorySwappiness(Long MemorySwappiness) {
        this.MemorySwappiness = MemorySwappiness;
        return (A)this;
    }

    @Override
    public String getNetworkMode() {
        return this.NetworkMode;
    }

    @Override
    public A withNetworkMode(String NetworkMode) {
        this.NetworkMode = NetworkMode;
        return (A)this;
    }

    @Override
    public Boolean isOomKillDisable() {
        return this.OomKillDisable;
    }

    @Override
    public A withOomKillDisable(Boolean OomKillDisable) {
        this.OomKillDisable = OomKillDisable;
        return (A)this;
    }

    @Override
    public String getPidMode() {
        return this.PidMode;
    }

    @Override
    public A withPidMode(String PidMode) {
        this.PidMode = PidMode;
        return (A)this;
    }

    @Override
    public A addToPortBindings(String key, ArrayList<PortBinding> value) {
        if (key != null && value != null) {
            this.PortBindings.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPortBindings(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            this.PortBindings.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortBindings(String key) {
        if (key != null) {
            this.PortBindings.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortBindings(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.PortBindings.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<PortBinding>> getPortBindings() {
        return this.PortBindings;
    }

    @Override
    public A withPortBindings(Map<String, ArrayList<PortBinding>> PortBindings) {
        this.PortBindings.clear();
        if (PortBindings != null) {
            this.PortBindings.putAll(PortBindings);
        }
        return (A)this;
    }

    @Override
    public Boolean isPrivileged() {
        return this.Privileged;
    }

    @Override
    public A withPrivileged(Boolean Privileged) {
        this.Privileged = Privileged;
        return (A)this;
    }

    @Override
    public Boolean isPublishAllPorts() {
        return this.PublishAllPorts;
    }

    @Override
    public A withPublishAllPorts(Boolean PublishAllPorts) {
        this.PublishAllPorts = PublishAllPorts;
        return (A)this;
    }

    @Override
    public Boolean isReadonlyRootfs() {
        return this.ReadonlyRootfs;
    }

    @Override
    public A withReadonlyRootfs(Boolean ReadonlyRootfs) {
        this.ReadonlyRootfs = ReadonlyRootfs;
        return (A)this;
    }

    @Override
    public RestartPolicy getRestartPolicy() {
        return this.RestartPolicy != null ? (RestartPolicy)this.RestartPolicy.build() : null;
    }

    @Override
    public A withRestartPolicy(RestartPolicy RestartPolicy2) {
        this._visitables.remove(this.RestartPolicy);
        if (RestartPolicy2 != null) {
            this.RestartPolicy = new RestartPolicyBuilder(RestartPolicy2);
            this._visitables.add(this.RestartPolicy);
        }
        return (A)this;
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy() {
        return new RestartPolicyNestedImpl();
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item) {
        return new RestartPolicyNestedImpl(item);
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy() {
        return this.withNewRestartPolicyLike(this.getRestartPolicy());
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy() {
        return this.withNewRestartPolicyLike(this.getRestartPolicy() != null ? this.getRestartPolicy() : new RestartPolicyBuilder().build());
    }

    @Override
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item) {
        return this.withNewRestartPolicyLike(this.getRestartPolicy() != null ? this.getRestartPolicy() : item);
    }

    @Override
    public A withNewRestartPolicy(Integer MaximumRetryCount, String Name) {
        return this.withRestartPolicy(new RestartPolicy(MaximumRetryCount, Name));
    }

    @Override
    public A addToSecurityOpt(String ... items) {
        for (String item : items) {
            this.SecurityOpt.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecurityOpt(String ... items) {
        for (String item : items) {
            this.SecurityOpt.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSecurityOpt() {
        return this.SecurityOpt;
    }

    @Override
    public A withSecurityOpt(List<String> SecurityOpt) {
        this.SecurityOpt.clear();
        if (SecurityOpt != null) {
            for (String item : SecurityOpt) {
                this.addToSecurityOpt(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecurityOpt(String ... SecurityOpt) {
        this.SecurityOpt.clear();
        if (SecurityOpt != null) {
            for (String item : SecurityOpt) {
                this.addToSecurityOpt(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getUTSMode() {
        return this.UTSMode;
    }

    @Override
    public A withUTSMode(String UTSMode) {
        this.UTSMode = UTSMode;
        return (A)this;
    }

    @Override
    public A addToUlimits(Ulimit ... items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.add(builder);
            this.Ulimits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromUlimits(Ulimit ... items) {
        for (Ulimit item : items) {
            UlimitBuilder builder = new UlimitBuilder(item);
            this._visitables.remove(builder);
            this.Ulimits.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Ulimit> getUlimits() {
        return HostConfigFluentImpl.build(this.Ulimits);
    }

    @Override
    public A withUlimits(List<Ulimit> Ulimits) {
        this._visitables.removeAll(this.Ulimits);
        this.Ulimits.clear();
        if (Ulimits != null) {
            for (Ulimit item : Ulimits) {
                this.addToUlimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUlimits(Ulimit ... Ulimits) {
        this.Ulimits.clear();
        if (Ulimits != null) {
            for (Ulimit item : Ulimits) {
                this.addToUlimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> addNewUlimit() {
        return new UlimitsNestedImpl();
    }

    @Override
    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item) {
        return new UlimitsNestedImpl(item);
    }

    @Override
    public A addNewUlimit(Long Hard, String Name, Long Soft) {
        return this.addToUlimits(new Ulimit(Hard, Name, Soft));
    }

    @Override
    public String getVolumeDriver() {
        return this.VolumeDriver;
    }

    @Override
    public A withVolumeDriver(String VolumeDriver) {
        this.VolumeDriver = VolumeDriver;
        return (A)this;
    }

    @Override
    public A addToVolumesFrom(String ... items) {
        for (String item : items) {
            this.VolumesFrom.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesFrom(String ... items) {
        for (String item : items) {
            this.VolumesFrom.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumesFrom() {
        return this.VolumesFrom;
    }

    @Override
    public A withVolumesFrom(List<String> VolumesFrom) {
        this.VolumesFrom.clear();
        if (VolumesFrom != null) {
            for (String item : VolumesFrom) {
                this.addToVolumesFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumesFrom(String ... VolumesFrom) {
        this.VolumesFrom.clear();
        if (VolumesFrom != null) {
            for (String item : VolumesFrom) {
                this.addToVolumesFrom(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostConfigFluentImpl that = (HostConfigFluentImpl)o;
        if (this.Binds != null ? !this.Binds.equals(that.Binds) : that.Binds != null) {
            return false;
        }
        if (this.BlkioWeight != null ? !this.BlkioWeight.equals(that.BlkioWeight) : that.BlkioWeight != null) {
            return false;
        }
        if (this.CapAdd != null ? !this.CapAdd.equals(that.CapAdd) : that.CapAdd != null) {
            return false;
        }
        if (this.CapDrop != null ? !this.CapDrop.equals(that.CapDrop) : that.CapDrop != null) {
            return false;
        }
        if (this.CgroupParent != null ? !this.CgroupParent.equals(that.CgroupParent) : that.CgroupParent != null) {
            return false;
        }
        if (this.ConsoleSize != null && this.ConsoleSize != this ? !this.ConsoleSize.equals(that.ConsoleSize) : that.ConsoleSize != null && this.ConsoleSize != this) {
            return false;
        }
        if (this.ContainerIDFile != null ? !this.ContainerIDFile.equals(that.ContainerIDFile) : that.ContainerIDFile != null) {
            return false;
        }
        if (this.CpuPeriod != null ? !this.CpuPeriod.equals(that.CpuPeriod) : that.CpuPeriod != null) {
            return false;
        }
        if (this.CpuQuota != null ? !this.CpuQuota.equals(that.CpuQuota) : that.CpuQuota != null) {
            return false;
        }
        if (this.CpuShares != null ? !this.CpuShares.equals(that.CpuShares) : that.CpuShares != null) {
            return false;
        }
        if (this.CpusetCpus != null ? !this.CpusetCpus.equals(that.CpusetCpus) : that.CpusetCpus != null) {
            return false;
        }
        if (this.CpusetMems != null ? !this.CpusetMems.equals(that.CpusetMems) : that.CpusetMems != null) {
            return false;
        }
        if (this.Devices != null ? !this.Devices.equals(that.Devices) : that.Devices != null) {
            return false;
        }
        if (this.Dns != null ? !this.Dns.equals(that.Dns) : that.Dns != null) {
            return false;
        }
        if (this.DnsOptions != null ? !this.DnsOptions.equals(that.DnsOptions) : that.DnsOptions != null) {
            return false;
        }
        if (this.DnsSearch != null ? !this.DnsSearch.equals(that.DnsSearch) : that.DnsSearch != null) {
            return false;
        }
        if (this.ExtraHosts != null ? !this.ExtraHosts.equals(that.ExtraHosts) : that.ExtraHosts != null) {
            return false;
        }
        if (this.GroupAdd != null ? !this.GroupAdd.equals(that.GroupAdd) : that.GroupAdd != null) {
            return false;
        }
        if (this.IpcMode != null ? !this.IpcMode.equals(that.IpcMode) : that.IpcMode != null) {
            return false;
        }
        if (this.KernelMemory != null ? !this.KernelMemory.equals(that.KernelMemory) : that.KernelMemory != null) {
            return false;
        }
        if (this.Links != null ? !this.Links.equals(that.Links) : that.Links != null) {
            return false;
        }
        if (this.LogConfig != null ? !this.LogConfig.equals(that.LogConfig) : that.LogConfig != null) {
            return false;
        }
        if (this.LxcConf != null ? !this.LxcConf.equals(that.LxcConf) : that.LxcConf != null) {
            return false;
        }
        if (this.Memory != null ? !this.Memory.equals(that.Memory) : that.Memory != null) {
            return false;
        }
        if (this.MemoryReservation != null ? !this.MemoryReservation.equals(that.MemoryReservation) : that.MemoryReservation != null) {
            return false;
        }
        if (this.MemorySwap != null ? !this.MemorySwap.equals(that.MemorySwap) : that.MemorySwap != null) {
            return false;
        }
        if (this.MemorySwappiness != null ? !this.MemorySwappiness.equals(that.MemorySwappiness) : that.MemorySwappiness != null) {
            return false;
        }
        if (this.NetworkMode != null ? !this.NetworkMode.equals(that.NetworkMode) : that.NetworkMode != null) {
            return false;
        }
        if (this.OomKillDisable != null ? !this.OomKillDisable.equals(that.OomKillDisable) : that.OomKillDisable != null) {
            return false;
        }
        if (this.PidMode != null ? !this.PidMode.equals(that.PidMode) : that.PidMode != null) {
            return false;
        }
        if (this.PortBindings != null ? !this.PortBindings.equals(that.PortBindings) : that.PortBindings != null) {
            return false;
        }
        if (this.Privileged != null ? !this.Privileged.equals(that.Privileged) : that.Privileged != null) {
            return false;
        }
        if (this.PublishAllPorts != null ? !this.PublishAllPorts.equals(that.PublishAllPorts) : that.PublishAllPorts != null) {
            return false;
        }
        if (this.ReadonlyRootfs != null ? !this.ReadonlyRootfs.equals(that.ReadonlyRootfs) : that.ReadonlyRootfs != null) {
            return false;
        }
        if (this.RestartPolicy != null ? !this.RestartPolicy.equals(that.RestartPolicy) : that.RestartPolicy != null) {
            return false;
        }
        if (this.SecurityOpt != null ? !this.SecurityOpt.equals(that.SecurityOpt) : that.SecurityOpt != null) {
            return false;
        }
        if (this.UTSMode != null ? !this.UTSMode.equals(that.UTSMode) : that.UTSMode != null) {
            return false;
        }
        if (this.Ulimits != null ? !this.Ulimits.equals(that.Ulimits) : that.Ulimits != null) {
            return false;
        }
        if (this.VolumeDriver != null ? !this.VolumeDriver.equals(that.VolumeDriver) : that.VolumeDriver != null) {
            return false;
        }
        return !(this.VolumesFrom != null ? !this.VolumesFrom.equals(that.VolumesFrom) : that.VolumesFrom != null);
    }

    public class UlimitsNestedImpl<N>
    extends UlimitFluentImpl<HostConfigFluent.UlimitsNested<N>>
    implements HostConfigFluent.UlimitsNested<N>,
    Nested<N> {
        private final UlimitBuilder builder;

        UlimitsNestedImpl(Ulimit item) {
            this.builder = new UlimitBuilder(this, item);
        }

        UlimitsNestedImpl() {
            this.builder = new UlimitBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.addToUlimits(this.builder.build());
        }

        @Override
        public N endUlimit() {
            return this.and();
        }
    }

    public class RestartPolicyNestedImpl<N>
    extends RestartPolicyFluentImpl<HostConfigFluent.RestartPolicyNested<N>>
    implements HostConfigFluent.RestartPolicyNested<N>,
    Nested<N> {
        private final RestartPolicyBuilder builder;

        RestartPolicyNestedImpl(RestartPolicy item) {
            this.builder = new RestartPolicyBuilder(this, item);
        }

        RestartPolicyNestedImpl() {
            this.builder = new RestartPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.withRestartPolicy(this.builder.build());
        }

        @Override
        public N endRestartPolicy() {
            return this.and();
        }
    }

    public class LogConfigNestedImpl<N>
    extends LogConfigFluentImpl<HostConfigFluent.LogConfigNested<N>>
    implements HostConfigFluent.LogConfigNested<N>,
    Nested<N> {
        private final LogConfigBuilder builder;

        LogConfigNestedImpl(LogConfig item) {
            this.builder = new LogConfigBuilder(this, item);
        }

        LogConfigNestedImpl() {
            this.builder = new LogConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.withLogConfig(this.builder.build());
        }

        @Override
        public N endLogConfig() {
            return this.and();
        }
    }

    public class DevicesNestedImpl<N>
    extends DeviceMappingFluentImpl<HostConfigFluent.DevicesNested<N>>
    implements HostConfigFluent.DevicesNested<N>,
    Nested<N> {
        private final DeviceMappingBuilder builder;

        DevicesNestedImpl(DeviceMapping item) {
            this.builder = new DeviceMappingBuilder(this, item);
        }

        DevicesNestedImpl() {
            this.builder = new DeviceMappingBuilder(this);
        }

        @Override
        public N and() {
            return (N)HostConfigFluentImpl.this.addToDevices(this.builder.build());
        }

        @Override
        public N endDevice() {
            return this.and();
        }
    }
}

