/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableExecConfig;
import io.fabric8.docker.api.model.ExecConfig;
import io.fabric8.docker.api.model.ExecConfigFluent;
import io.fabric8.docker.api.model.ExecConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ExecConfigBuilder
extends ExecConfigFluentImpl<ExecConfigBuilder>
implements VisitableBuilder<ExecConfig, ExecConfigBuilder> {
    ExecConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExecConfigBuilder() {
        this(true);
    }

    public ExecConfigBuilder(Boolean validationEnabled) {
        this(new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance) {
        this(fluent, instance, true);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAttachStderr(instance.getAttachStderr());
        fluent.withAttachStdin(instance.getAttachStdin());
        fluent.withAttachStdout(instance.getAttachStdout());
        fluent.withCmd(instance.getCmd());
        fluent.withContainer(instance.getContainer());
        fluent.withDetach(instance.getDetach());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withTty(instance.getTty());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public ExecConfigBuilder(ExecConfig instance) {
        this(instance, (Boolean)true);
    }

    public ExecConfigBuilder(ExecConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAttachStderr(instance.getAttachStderr());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withCmd(instance.getCmd());
        this.withContainer(instance.getContainer());
        this.withDetach(instance.getDetach());
        this.withPrivileged(instance.getPrivileged());
        this.withTty(instance.getTty());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableExecConfig build() {
        EditableExecConfig buildable = new EditableExecConfig(this.fluent.isAttachStderr(), this.fluent.isAttachStdin(), this.fluent.isAttachStdout(), this.fluent.getCmd(), this.fluent.getContainer(), this.fluent.isDetach(), this.fluent.isPrivileged(), this.fluent.isTty(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecConfigBuilder that = (ExecConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

