/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableEndpointResource;
import io.fabric8.docker.api.model.EndpointResource;
import io.fabric8.docker.api.model.EndpointResourceFluent;
import io.fabric8.docker.api.model.EndpointResourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointResourceBuilder
extends EndpointResourceFluentImpl<EndpointResourceBuilder>
implements VisitableBuilder<EndpointResource, EndpointResourceBuilder> {
    EndpointResourceFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointResourceBuilder() {
        this(true);
    }

    public EndpointResourceBuilder(Boolean validationEnabled) {
        this(new EndpointResource(), validationEnabled);
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointResource(), validationEnabled);
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent, EndpointResource instance) {
        this(fluent, instance, true);
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent, EndpointResource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withIPv4Address(instance.getIPv4Address());
        fluent.withIPv6Address(instance.getIPv6Address());
        fluent.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    public EndpointResourceBuilder(EndpointResource instance) {
        this(instance, (Boolean)true);
    }

    public EndpointResourceBuilder(EndpointResource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withIPv4Address(instance.getIPv4Address());
        this.withIPv6Address(instance.getIPv6Address());
        this.withMacAddress(instance.getMacAddress());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableEndpointResource build() {
        EditableEndpointResource buildable = new EditableEndpointResource(this.fluent.getEndpointID(), this.fluent.getIPv4Address(), this.fluent.getIPv6Address(), this.fluent.getMacAddress());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointResourceBuilder that = (EndpointResourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

