/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.DeviceMapping;
import io.fabric8.docker.api.model.DeviceMappingFluent;
import io.fabric8.docker.api.model.DeviceMappingFluentImpl;
import io.fabric8.docker.api.model.EditableDeviceMapping;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeviceMappingBuilder
extends DeviceMappingFluentImpl<DeviceMappingBuilder>
implements VisitableBuilder<DeviceMapping, DeviceMappingBuilder> {
    DeviceMappingFluent<?> fluent;
    Boolean validationEnabled;

    public DeviceMappingBuilder() {
        this(true);
    }

    public DeviceMappingBuilder(Boolean validationEnabled) {
        this(new DeviceMapping(), validationEnabled);
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeviceMapping(), validationEnabled);
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent, DeviceMapping instance) {
        this(fluent, instance, true);
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent, DeviceMapping instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCgroupPermissions(instance.getCgroupPermissions());
        fluent.withPathInContainer(instance.getPathInContainer());
        fluent.withPathOnHost(instance.getPathOnHost());
        this.validationEnabled = validationEnabled;
    }

    public DeviceMappingBuilder(DeviceMapping instance) {
        this(instance, (Boolean)true);
    }

    public DeviceMappingBuilder(DeviceMapping instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCgroupPermissions(instance.getCgroupPermissions());
        this.withPathInContainer(instance.getPathInContainer());
        this.withPathOnHost(instance.getPathOnHost());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableDeviceMapping build() {
        EditableDeviceMapping buildable = new EditableDeviceMapping(this.fluent.getCgroupPermissions(), this.fluent.getPathInContainer(), this.fluent.getPathOnHost());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceMappingBuilder that = (DeviceMappingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

