/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CopyConfig;
import io.fabric8.docker.api.model.CopyConfigFluent;
import io.fabric8.docker.api.model.CopyConfigFluentImpl;
import io.fabric8.docker.api.model.EditableCopyConfig;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CopyConfigBuilder
extends CopyConfigFluentImpl<CopyConfigBuilder>
implements VisitableBuilder<CopyConfig, CopyConfigBuilder> {
    CopyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public CopyConfigBuilder() {
        this(true);
    }

    public CopyConfigBuilder(Boolean validationEnabled) {
        this(new CopyConfig(), validationEnabled);
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CopyConfig(), validationEnabled);
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent, CopyConfig instance) {
        this(fluent, instance, true);
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent, CopyConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResource(instance.getResource());
        this.validationEnabled = validationEnabled;
    }

    public CopyConfigBuilder(CopyConfig instance) {
        this(instance, (Boolean)true);
    }

    public CopyConfigBuilder(CopyConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResource(instance.getResource());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableCopyConfig build() {
        EditableCopyConfig buildable = new EditableCopyConfig(this.fluent.getResource());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyConfigBuilder that = (CopyConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

