/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerWaitResponse;
import io.fabric8.docker.api.model.ContainerWaitResponseFluent;
import io.fabric8.docker.api.model.ContainerWaitResponseFluentImpl;
import io.fabric8.docker.api.model.EditableContainerWaitResponse;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerWaitResponseBuilder
extends ContainerWaitResponseFluentImpl<ContainerWaitResponseBuilder>
implements VisitableBuilder<ContainerWaitResponse, ContainerWaitResponseBuilder> {
    ContainerWaitResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerWaitResponseBuilder() {
        this(true);
    }

    public ContainerWaitResponseBuilder(Boolean validationEnabled) {
        this(new ContainerWaitResponse(), validationEnabled);
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerWaitResponse(), validationEnabled);
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent, ContainerWaitResponse instance) {
        this(fluent, instance, true);
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent, ContainerWaitResponse instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStatusCode(instance.getStatusCode());
        this.validationEnabled = validationEnabled;
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponse instance) {
        this(instance, (Boolean)true);
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponse instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStatusCode(instance.getStatusCode());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerWaitResponse build() {
        EditableContainerWaitResponse buildable = new EditableContainerWaitResponse(this.fluent.getStatusCode());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerWaitResponseBuilder that = (ContainerWaitResponseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

