/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Container;
import io.fabric8.docker.api.model.ContainerFluent;
import io.fabric8.docker.api.model.ContainerHostConfig;
import io.fabric8.docker.api.model.ContainerHostConfigBuilder;
import io.fabric8.docker.api.model.ContainerHostConfigFluentImpl;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsBuilder;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import io.fabric8.docker.api.model.Port;
import io.fabric8.docker.api.model.PortBuilder;
import io.fabric8.docker.api.model.PortFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluentImpl<A extends ContainerFluent<A>>
extends BaseFluent<A>
implements ContainerFluent<A> {
    private String id;
    private List<String> names = new ArrayList<String>();
    private String image;
    private String imageId;
    private String command;
    private Long created;
    private List<VisitableBuilder<? extends Port, ?>> ports = new ArrayList();
    private Long sizeRw;
    private Long sizeRootFs;
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    private String status;
    private VisitableBuilder<? extends ContainerHostConfig, ?> hostConfig;
    private VisitableBuilder<? extends NetworkSettings, ?> summaryNetworkSettings;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withId(instance.getId());
        this.withNames(instance.getNames());
        this.withImage(instance.getImage());
        this.withImageId(instance.getImageId());
        this.withCommand(instance.getCommand());
        this.withCreated(instance.getCreated());
        this.withPorts(instance.getPorts());
        this.withSizeRw(instance.getSizeRw());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withLabels(instance.getLabels());
        this.withStatus(instance.getStatus());
        this.withHostConfig(instance.getHostConfig());
        this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public A withNames(List<String> names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public A withImageId(String imageId) {
        this.imageId = imageId;
        return (A)this;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public A withCommand(String command) {
        this.command = command;
        return (A)this;
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public A withCreated(Long created) {
        this.created = created;
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Port> getPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public A withPorts(List<Port> ports) {
        this._visitables.removeAll(this.ports);
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(Port ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public A addNewPort(String IP, Integer PrivatePort, Integer PublicPort, String Type2) {
        return this.addToPorts(new Port(IP, PrivatePort, PublicPort, Type2));
    }

    @Override
    public Long getSizeRw() {
        return this.sizeRw;
    }

    @Override
    public A withSizeRw(Long sizeRw) {
        this.sizeRw = sizeRw;
        return (A)this;
    }

    @Override
    public Long getSizeRootFs() {
        return this.sizeRootFs;
    }

    @Override
    public A withSizeRootFs(Long sizeRootFs) {
        this.sizeRootFs = sizeRootFs;
        return (A)this;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (A)this;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public ContainerHostConfig getHostConfig() {
        return this.hostConfig != null ? (ContainerHostConfig)this.hostConfig.build() : null;
    }

    @Override
    public A withHostConfig(ContainerHostConfig hostConfig) {
        this._visitables.remove(this.hostConfig);
        if (hostConfig != null) {
            this.hostConfig = new ContainerHostConfigBuilder(hostConfig);
            this._visitables.add(this.hostConfig);
        }
        return (A)this;
    }

    @Override
    public ContainerFluent.HostConfigNested<A> withNewHostConfig() {
        return new HostConfigNestedImpl();
    }

    @Override
    public ContainerFluent.HostConfigNested<A> withNewHostConfigLike(ContainerHostConfig item) {
        return new HostConfigNestedImpl(item);
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig());
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : new ContainerHostConfigBuilder().build());
    }

    @Override
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfigLike(ContainerHostConfig item) {
        return this.withNewHostConfigLike(this.getHostConfig() != null ? this.getHostConfig() : item);
    }

    @Override
    public A withNewHostConfig(String networkMode) {
        return this.withHostConfig(new ContainerHostConfig(networkMode));
    }

    @Override
    public NetworkSettings getSummaryNetworkSettings() {
        return this.summaryNetworkSettings != null ? (NetworkSettings)this.summaryNetworkSettings.build() : null;
    }

    @Override
    public A withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings) {
        this._visitables.remove(this.summaryNetworkSettings);
        if (summaryNetworkSettings != null) {
            this.summaryNetworkSettings = new NetworkSettingsBuilder(summaryNetworkSettings);
            this._visitables.add(this.summaryNetworkSettings);
        }
        return (A)this;
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettings() {
        return new SummaryNetworkSettingsNestedImpl();
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettingsLike(NetworkSettings item) {
        return new SummaryNetworkSettingsNestedImpl(item);
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editSummaryNetworkSettings() {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings());
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettings() {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings() != null ? this.getSummaryNetworkSettings() : new NetworkSettingsBuilder().build());
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettingsLike(NetworkSettings item) {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings() != null ? this.getSummaryNetworkSettings() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.sizeRw != null ? !this.sizeRw.equals(that.sizeRw) : that.sizeRw != null) {
            return false;
        }
        if (this.sizeRootFs != null ? !this.sizeRootFs.equals(that.sizeRootFs) : that.sizeRootFs != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null) {
            return false;
        }
        return !(this.summaryNetworkSettings != null ? !this.summaryNetworkSettings.equals(that.summaryNetworkSettings) : that.summaryNetworkSettings != null);
    }

    public class SummaryNetworkSettingsNestedImpl<N>
    extends NetworkSettingsFluentImpl<ContainerFluent.SummaryNetworkSettingsNested<N>>
    implements ContainerFluent.SummaryNetworkSettingsNested<N>,
    Nested<N> {
        private final NetworkSettingsBuilder builder;

        SummaryNetworkSettingsNestedImpl(NetworkSettings item) {
            this.builder = new NetworkSettingsBuilder(this, item);
        }

        SummaryNetworkSettingsNestedImpl() {
            this.builder = new NetworkSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSummaryNetworkSettings(this.builder.build());
        }

        @Override
        public N endSummaryNetworkSettings() {
            return this.and();
        }
    }

    public class HostConfigNestedImpl<N>
    extends ContainerHostConfigFluentImpl<ContainerFluent.HostConfigNested<N>>
    implements ContainerFluent.HostConfigNested<N>,
    Nested<N> {
        private final ContainerHostConfigBuilder builder;

        HostConfigNestedImpl(ContainerHostConfig item) {
            this.builder = new ContainerHostConfigBuilder(this, item);
        }

        HostConfigNestedImpl() {
            this.builder = new ContainerHostConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withHostConfig(this.builder.build());
        }

        @Override
        public N endHostConfig() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;

        PortsNestedImpl(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.addToPorts(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

