/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerCommitResponse;
import io.fabric8.docker.api.model.ContainerCommitResponseFluent;
import io.fabric8.docker.api.model.ContainerCommitResponseFluentImpl;
import io.fabric8.docker.api.model.EditableContainerCommitResponse;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerCommitResponseBuilder
extends ContainerCommitResponseFluentImpl<ContainerCommitResponseBuilder>
implements VisitableBuilder<ContainerCommitResponse, ContainerCommitResponseBuilder> {
    ContainerCommitResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerCommitResponseBuilder() {
        this(true);
    }

    public ContainerCommitResponseBuilder(Boolean validationEnabled) {
        this(new ContainerCommitResponse(), validationEnabled);
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerCommitResponse(), validationEnabled);
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent, ContainerCommitResponse instance) {
        this(fluent, instance, true);
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponseFluent<?> fluent, ContainerCommitResponse instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withId(instance.getId());
        this.validationEnabled = validationEnabled;
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponse instance) {
        this(instance, (Boolean)true);
    }

    public ContainerCommitResponseBuilder(ContainerCommitResponse instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withId(instance.getId());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableContainerCommitResponse build() {
        EditableContainerCommitResponse buildable = new EditableContainerCommitResponse(this.fluent.getId());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerCommitResponseBuilder that = (ContainerCommitResponseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

