/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Config;
import io.fabric8.docker.api.model.ConfigFluent;
import io.fabric8.docker.api.model.ConfigFluentImpl;
import io.fabric8.docker.api.model.EditableConfig;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder() {
        this(true);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, true);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAttachStderr(instance.getAttachStderr());
        fluent.withAttachStdin(instance.getAttachStdin());
        fluent.withAttachStdout(instance.getAttachStdout());
        fluent.withCmd(instance.getCmd());
        fluent.withDomainname(instance.getDomainname());
        fluent.withEntrypoint(instance.getEntrypoint());
        fluent.withEnv(instance.getEnv());
        fluent.withExposedPorts(instance.getExposedPorts());
        fluent.withHostname(instance.getHostname());
        fluent.withImage(instance.getImage());
        fluent.withLabels(instance.getLabels());
        fluent.withMacAddress(instance.getMacAddress());
        fluent.withNetworkDisabled(instance.getNetworkDisabled());
        fluent.withOnBuild(instance.getOnBuild());
        fluent.withOpenStdin(instance.getOpenStdin());
        fluent.withPublishService(instance.getPublishService());
        fluent.withStdinOnce(instance.getStdinOnce());
        fluent.withStopSignal(instance.getStopSignal());
        fluent.withTty(instance.getTty());
        fluent.withUser(instance.getUser());
        fluent.withVolumes(instance.getVolumes());
        fluent.withWorkingDir(instance.getWorkingDir());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)true);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAttachStderr(instance.getAttachStderr());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withCmd(instance.getCmd());
        this.withDomainname(instance.getDomainname());
        this.withEntrypoint(instance.getEntrypoint());
        this.withEnv(instance.getEnv());
        this.withExposedPorts(instance.getExposedPorts());
        this.withHostname(instance.getHostname());
        this.withImage(instance.getImage());
        this.withLabels(instance.getLabels());
        this.withMacAddress(instance.getMacAddress());
        this.withNetworkDisabled(instance.getNetworkDisabled());
        this.withOnBuild(instance.getOnBuild());
        this.withOpenStdin(instance.getOpenStdin());
        this.withPublishService(instance.getPublishService());
        this.withStdinOnce(instance.getStdinOnce());
        this.withStopSignal(instance.getStopSignal());
        this.withTty(instance.getTty());
        this.withUser(instance.getUser());
        this.withVolumes(instance.getVolumes());
        this.withWorkingDir(instance.getWorkingDir());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableConfig build() {
        EditableConfig buildable = new EditableConfig(this.fluent.isAttachStderr(), this.fluent.isAttachStdin(), this.fluent.isAttachStdout(), this.fluent.getCmd(), this.fluent.getDomainname(), this.fluent.getEntrypoint(), this.fluent.getEnv(), this.fluent.getExposedPorts(), this.fluent.getHostname(), this.fluent.getImage(), this.fluent.getLabels(), this.fluent.getMacAddress(), this.fluent.isNetworkDisabled(), this.fluent.getOnBuild(), this.fluent.isOpenStdin(), this.fluent.getPublishService(), this.fluent.isStdinOnce(), this.fluent.getStopSignal(), this.fluent.isTty(), this.fluent.getUser(), this.fluent.getVolumes(), this.fluent.getWorkingDir());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

