/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CPUUsage;
import io.fabric8.docker.api.model.CPUUsageFluent;
import io.fabric8.docker.api.model.CPUUsageFluentImpl;
import io.fabric8.docker.api.model.EditableCPUUsage;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CPUUsageBuilder
extends CPUUsageFluentImpl<CPUUsageBuilder>
implements VisitableBuilder<CPUUsage, CPUUsageBuilder> {
    CPUUsageFluent<?> fluent;
    Boolean validationEnabled;

    public CPUUsageBuilder() {
        this(true);
    }

    public CPUUsageBuilder(Boolean validationEnabled) {
        this(new CPUUsage(), validationEnabled);
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CPUUsage(), validationEnabled);
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent, CPUUsage instance) {
        this(fluent, instance, true);
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent, CPUUsage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPercpuUsage(instance.getPercpuUsage());
        fluent.withTotalUsage(instance.getTotalUsage());
        fluent.withUsageInKernelmode(instance.getUsageInKernelmode());
        fluent.withUsageInUsermode(instance.getUsageInUsermode());
        this.validationEnabled = validationEnabled;
    }

    public CPUUsageBuilder(CPUUsage instance) {
        this(instance, (Boolean)true);
    }

    public CPUUsageBuilder(CPUUsage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPercpuUsage(instance.getPercpuUsage());
        this.withTotalUsage(instance.getTotalUsage());
        this.withUsageInKernelmode(instance.getUsageInKernelmode());
        this.withUsageInUsermode(instance.getUsageInUsermode());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableCPUUsage build() {
        EditableCPUUsage buildable = new EditableCPUUsage(this.fluent.getPercpuUsage(), this.fluent.getTotalUsage(), this.fluent.getUsageInKernelmode(), this.fluent.getUsageInUsermode());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUUsageBuilder that = (CPUUsageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

