/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.BlkioStats;
import io.fabric8.docker.api.model.BlkioStatsFluent;
import io.fabric8.docker.api.model.BlkioStatsFluentImpl;
import io.fabric8.docker.api.model.EditableBlkioStats;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BlkioStatsBuilder
extends BlkioStatsFluentImpl<BlkioStatsBuilder>
implements VisitableBuilder<BlkioStats, BlkioStatsBuilder> {
    BlkioStatsFluent<?> fluent;
    Boolean validationEnabled;

    public BlkioStatsBuilder() {
        this(true);
    }

    public BlkioStatsBuilder(Boolean validationEnabled) {
        this(new BlkioStats(), validationEnabled);
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BlkioStats(), validationEnabled);
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent, BlkioStats instance) {
        this(fluent, instance, true);
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent, BlkioStats instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIoMergedRecursive(instance.getIoMergedRecursive());
        fluent.withIoQueueRecursive(instance.getIoQueueRecursive());
        fluent.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive());
        fluent.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive());
        fluent.withIoServicedRecursive(instance.getIoServicedRecursive());
        fluent.withIoTimeRecursive(instance.getIoTimeRecursive());
        fluent.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive());
        fluent.withSectorsRecursive(instance.getSectorsRecursive());
        this.validationEnabled = validationEnabled;
    }

    public BlkioStatsBuilder(BlkioStats instance) {
        this(instance, (Boolean)true);
    }

    public BlkioStatsBuilder(BlkioStats instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIoMergedRecursive(instance.getIoMergedRecursive());
        this.withIoQueueRecursive(instance.getIoQueueRecursive());
        this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive());
        this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive());
        this.withIoServicedRecursive(instance.getIoServicedRecursive());
        this.withIoTimeRecursive(instance.getIoTimeRecursive());
        this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive());
        this.withSectorsRecursive(instance.getSectorsRecursive());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableBlkioStats build() {
        EditableBlkioStats buildable = new EditableBlkioStats(this.fluent.getIoMergedRecursive(), this.fluent.getIoQueueRecursive(), this.fluent.getIoServiceBytesRecursive(), this.fluent.getIoServiceTimeRecursive(), this.fluent.getIoServicedRecursive(), this.fluent.getIoTimeRecursive(), this.fluent.getIoWaitTimeRecursive(), this.fluent.getSectorsRecursive());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlkioStatsBuilder that = (BlkioStatsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

