/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.BlkioStatEntry;
import io.fabric8.docker.api.model.BlkioStatEntryFluent;
import io.fabric8.docker.api.model.BlkioStatEntryFluentImpl;
import io.fabric8.docker.api.model.EditableBlkioStatEntry;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BlkioStatEntryBuilder
extends BlkioStatEntryFluentImpl<BlkioStatEntryBuilder>
implements VisitableBuilder<BlkioStatEntry, BlkioStatEntryBuilder> {
    BlkioStatEntryFluent<?> fluent;
    Boolean validationEnabled;

    public BlkioStatEntryBuilder() {
        this(true);
    }

    public BlkioStatEntryBuilder(Boolean validationEnabled) {
        this(new BlkioStatEntry(), validationEnabled);
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BlkioStatEntry(), validationEnabled);
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent, BlkioStatEntry instance) {
        this(fluent, instance, true);
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent, BlkioStatEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMajor(instance.getMajor());
        fluent.withMinor(instance.getMinor());
        fluent.withOp(instance.getOp());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public BlkioStatEntryBuilder(BlkioStatEntry instance) {
        this(instance, (Boolean)true);
    }

    public BlkioStatEntryBuilder(BlkioStatEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMajor(instance.getMajor());
        this.withMinor(instance.getMinor());
        this.withOp(instance.getOp());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableBlkioStatEntry build() {
        EditableBlkioStatEntry buildable = new EditableBlkioStatEntry(this.fluent.getMajor(), this.fluent.getMinor(), this.fluent.getOp(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlkioStatEntryBuilder that = (BlkioStatEntryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

