/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.AuthConfig;
import io.fabric8.docker.api.model.AuthConfigFluent;
import io.fabric8.docker.api.model.AuthConfigFluentImpl;
import io.fabric8.docker.api.model.EditableAuthConfig;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AuthConfigBuilder
extends AuthConfigFluentImpl<AuthConfigBuilder>
implements VisitableBuilder<AuthConfig, AuthConfigBuilder> {
    AuthConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AuthConfigBuilder() {
        this(true);
    }

    public AuthConfigBuilder(Boolean validationEnabled) {
        this(new AuthConfig(), validationEnabled);
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthConfig(), validationEnabled);
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent, AuthConfig instance) {
        this(fluent, instance, true);
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent, AuthConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuth(instance.getAuth());
        fluent.withEmail(instance.getEmail());
        fluent.withPassword(instance.getPassword());
        fluent.withServeraddress(instance.getServeraddress());
        fluent.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public AuthConfigBuilder(AuthConfig instance) {
        this(instance, (Boolean)true);
    }

    public AuthConfigBuilder(AuthConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuth(instance.getAuth());
        this.withEmail(instance.getEmail());
        this.withPassword(instance.getPassword());
        this.withServeraddress(instance.getServeraddress());
        this.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableAuthConfig build() {
        EditableAuthConfig buildable = new EditableAuthConfig(this.fluent.getAuth(), this.fluent.getEmail(), this.fluent.getPassword(), this.fluent.getServeraddress(), this.fluent.getUsername());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthConfigBuilder that = (AuthConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

