/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Address;
import io.fabric8.docker.api.model.AddressFluent;
import io.fabric8.docker.api.model.AddressFluentImpl;
import io.fabric8.docker.api.model.EditableAddress;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AddressBuilder
extends AddressFluentImpl<AddressBuilder>
implements VisitableBuilder<Address, AddressBuilder> {
    AddressFluent<?> fluent;
    Boolean validationEnabled;

    public AddressBuilder() {
        this(true);
    }

    public AddressBuilder(Boolean validationEnabled) {
        this(new Address(), validationEnabled);
    }

    public AddressBuilder(AddressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AddressBuilder(AddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Address(), validationEnabled);
    }

    public AddressBuilder(AddressFluent<?> fluent, Address instance) {
        this(fluent, instance, true);
    }

    public AddressBuilder(AddressFluent<?> fluent, Address instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddr(instance.getAddr());
        fluent.withPrefixLen(instance.getPrefixLen());
        this.validationEnabled = validationEnabled;
    }

    public AddressBuilder(Address instance) {
        this(instance, (Boolean)true);
    }

    public AddressBuilder(Address instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddr(instance.getAddr());
        this.withPrefixLen(instance.getPrefixLen());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableAddress build() {
        EditableAddress buildable = new EditableAddress(this.fluent.getAddr(), this.fluent.getPrefixLen());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddressBuilder that = (AddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

