package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class VolumesListResponseFluentImpl<A extends VolumesListResponseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements VolumesListResponseFluent<A>{

    private List<VisitableBuilder<? extends Volume,?>> Volumes =  new ArrayList<VisitableBuilder<? extends Volume,?>>();

    public VolumesListResponseFluentImpl(){
    }
    public VolumesListResponseFluentImpl(VolumesListResponse instance){
            this.withVolumes(instance.getVolumes()); 
    }

    public A addToVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.Volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.Volumes.remove(builder);} return (A)this;
    }

    public List<Volume> getVolumes(){
            return build(Volumes);
    }

    public A withVolumes(List<Volume> Volumes){
            _visitables.removeAll(this.Volumes);
            this.Volumes.clear();
            if (Volumes != null) {for (Volume item : Volumes){this.addToVolumes(item);}} return (A) this;
    }

    public A withVolumes(Volume... Volumes){
            this.Volumes.clear(); if (Volumes != null) {for (Volume item :Volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public VolumesListResponseFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public VolumesListResponseFluent.VolumesNested<A> addNewVolumeLike(Volume item){
            return new VolumesNestedImpl(item);
    }

    public A addNewVolume(String Driver,String Mountpoint,String Name){
            return (A)addToVolumes(new Volume(Driver, Mountpoint, Name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumesListResponseFluentImpl that = (VolumesListResponseFluentImpl) o;
            if (Volumes != null ? !Volumes.equals(that.Volumes) :that.Volumes != null) return false;
            return true;
    }


    public class VolumesNestedImpl<N> extends VolumeFluentImpl<VolumesListResponseFluent.VolumesNested<N>> implements VolumesListResponseFluent.VolumesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VolumeBuilder builder;
    
            VolumesNestedImpl(Volume item){
                    this.builder = new VolumeBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.builder = new VolumeBuilder(this);
            }
    
    public N and(){
            return (N) VolumesListResponseFluentImpl.this.addToVolumes(builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
