package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class VolumesListResponseBuilder extends VolumesListResponseFluentImpl<VolumesListResponseBuilder> implements VisitableBuilder<VolumesListResponse,VolumesListResponseBuilder>{

    VolumesListResponseFluent<?> fluent;
    Boolean validationEnabled;

    public VolumesListResponseBuilder(){
            this(true);
    }
    public VolumesListResponseBuilder(Boolean validationEnabled){
            this(new VolumesListResponse(), validationEnabled);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent){
            this(fluent, true);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolumesListResponse(), validationEnabled);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,VolumesListResponse instance){
            this(fluent, instance, true);
    }
    public VolumesListResponseBuilder(VolumesListResponseFluent<?> fluent,VolumesListResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumesListResponseBuilder(VolumesListResponse instance){
            this(instance,true);
    }
    public VolumesListResponseBuilder(VolumesListResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableVolumesListResponse build(){
            EditableVolumesListResponse buildable = new EditableVolumesListResponse(fluent.getVolumes());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumesListResponseBuilder that = (VolumesListResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
