package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class VolumeBuilder extends VolumeFluentImpl<VolumeBuilder> implements VisitableBuilder<Volume,VolumeBuilder>{

    VolumeFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeBuilder(){
            this(true);
    }
    public VolumeBuilder(Boolean validationEnabled){
            this(new Volume(), validationEnabled);
    }
    public VolumeBuilder(VolumeFluent<?> fluent){
            this(fluent, true);
    }
    public VolumeBuilder(VolumeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Volume(), validationEnabled);
    }
    public VolumeBuilder(VolumeFluent<?> fluent,Volume instance){
            this(fluent, instance, true);
    }
    public VolumeBuilder(VolumeFluent<?> fluent,Volume instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDriver(instance.getDriver()); 
            fluent.withMountpoint(instance.getMountpoint()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumeBuilder(Volume instance){
            this(instance,true);
    }
    public VolumeBuilder(Volume instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDriver(instance.getDriver()); 
            this.withMountpoint(instance.getMountpoint()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableVolume build(){
            EditableVolume buildable = new EditableVolume(fluent.getDriver(),fluent.getMountpoint(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeBuilder that = (VolumeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
