package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class StatsFluentImpl<A extends StatsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements StatsFluent<A>{

    private VisitableBuilder<? extends BlkioStats,?> blkioStats;
    private VisitableBuilder<? extends CPUStats,?> cpuStats;
    private VisitableBuilder<? extends MemoryStats,?> memoryStats;
    private VisitableBuilder<? extends CPUStats,?> precpuStats;
    private String read;

    public StatsFluentImpl(){
    }
    public StatsFluentImpl(Stats instance){
            this.withBlkioStats(instance.getBlkioStats()); 
            this.withCpuStats(instance.getCpuStats()); 
            this.withMemoryStats(instance.getMemoryStats()); 
            this.withPrecpuStats(instance.getPrecpuStats()); 
            this.withRead(instance.getRead()); 
    }

    public BlkioStats getBlkioStats(){
            return this.blkioStats!=null?this.blkioStats.build():null;
    }

    public A withBlkioStats(BlkioStats blkioStats){
            _visitables.remove(this.blkioStats);
            if (blkioStats!=null){ this.blkioStats= new BlkioStatsBuilder(blkioStats); _visitables.add(this.blkioStats);} return (A) this;
    }

    public StatsFluent.BlkioStatsNested<A> withNewBlkioStats(){
            return new BlkioStatsNestedImpl();
    }

    public StatsFluent.BlkioStatsNested<A> withNewBlkioStatsLike(BlkioStats item){
            return new BlkioStatsNestedImpl(item);
    }

    public StatsFluent.BlkioStatsNested<A> editBlkioStats(){
            return withNewBlkioStatsLike(getBlkioStats());
    }

    public StatsFluent.BlkioStatsNested<A> editOrNewBlkioStats(){
            return withNewBlkioStatsLike(getBlkioStats() != null ? getBlkioStats(): new BlkioStatsBuilder().build());
    }

    public StatsFluent.BlkioStatsNested<A> editOrNewBlkioStatsLike(BlkioStats item){
            return withNewBlkioStatsLike(getBlkioStats() != null ? getBlkioStats(): item);
    }

    public CPUStats getCpuStats(){
            return this.cpuStats!=null?this.cpuStats.build():null;
    }

    public A withCpuStats(CPUStats cpuStats){
            _visitables.remove(this.cpuStats);
            if (cpuStats!=null){ this.cpuStats= new CPUStatsBuilder(cpuStats); _visitables.add(this.cpuStats);} return (A) this;
    }

    public StatsFluent.CpuStatsNested<A> withNewCpuStats(){
            return new CpuStatsNestedImpl();
    }

    public StatsFluent.CpuStatsNested<A> withNewCpuStatsLike(CPUStats item){
            return new CpuStatsNestedImpl(item);
    }

    public StatsFluent.CpuStatsNested<A> editCpuStats(){
            return withNewCpuStatsLike(getCpuStats());
    }

    public StatsFluent.CpuStatsNested<A> editOrNewCpuStats(){
            return withNewCpuStatsLike(getCpuStats() != null ? getCpuStats(): new CPUStatsBuilder().build());
    }

    public StatsFluent.CpuStatsNested<A> editOrNewCpuStatsLike(CPUStats item){
            return withNewCpuStatsLike(getCpuStats() != null ? getCpuStats(): item);
    }

    public MemoryStats getMemoryStats(){
            return this.memoryStats!=null?this.memoryStats.build():null;
    }

    public A withMemoryStats(MemoryStats memoryStats){
            _visitables.remove(this.memoryStats);
            if (memoryStats!=null){ this.memoryStats= new MemoryStatsBuilder(memoryStats); _visitables.add(this.memoryStats);} return (A) this;
    }

    public StatsFluent.MemoryStatsNested<A> withNewMemoryStats(){
            return new MemoryStatsNestedImpl();
    }

    public StatsFluent.MemoryStatsNested<A> withNewMemoryStatsLike(MemoryStats item){
            return new MemoryStatsNestedImpl(item);
    }

    public StatsFluent.MemoryStatsNested<A> editMemoryStats(){
            return withNewMemoryStatsLike(getMemoryStats());
    }

    public StatsFluent.MemoryStatsNested<A> editOrNewMemoryStats(){
            return withNewMemoryStatsLike(getMemoryStats() != null ? getMemoryStats(): new MemoryStatsBuilder().build());
    }

    public StatsFluent.MemoryStatsNested<A> editOrNewMemoryStatsLike(MemoryStats item){
            return withNewMemoryStatsLike(getMemoryStats() != null ? getMemoryStats(): item);
    }

    public CPUStats getPrecpuStats(){
            return this.precpuStats!=null?this.precpuStats.build():null;
    }

    public A withPrecpuStats(CPUStats precpuStats){
            _visitables.remove(this.precpuStats);
            if (precpuStats!=null){ this.precpuStats= new CPUStatsBuilder(precpuStats); _visitables.add(this.precpuStats);} return (A) this;
    }

    public StatsFluent.PrecpuStatsNested<A> withNewPrecpuStats(){
            return new PrecpuStatsNestedImpl();
    }

    public StatsFluent.PrecpuStatsNested<A> withNewPrecpuStatsLike(CPUStats item){
            return new PrecpuStatsNestedImpl(item);
    }

    public StatsFluent.PrecpuStatsNested<A> editPrecpuStats(){
            return withNewPrecpuStatsLike(getPrecpuStats());
    }

    public StatsFluent.PrecpuStatsNested<A> editOrNewPrecpuStats(){
            return withNewPrecpuStatsLike(getPrecpuStats() != null ? getPrecpuStats(): new CPUStatsBuilder().build());
    }

    public StatsFluent.PrecpuStatsNested<A> editOrNewPrecpuStatsLike(CPUStats item){
            return withNewPrecpuStatsLike(getPrecpuStats() != null ? getPrecpuStats(): item);
    }

    public String getRead(){
            return this.read;
    }

    public A withRead(String read){
            this.read=read; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsFluentImpl that = (StatsFluentImpl) o;
            if (blkioStats != null ? !blkioStats.equals(that.blkioStats) :that.blkioStats != null) return false;
            if (cpuStats != null ? !cpuStats.equals(that.cpuStats) :that.cpuStats != null) return false;
            if (memoryStats != null ? !memoryStats.equals(that.memoryStats) :that.memoryStats != null) return false;
            if (precpuStats != null ? !precpuStats.equals(that.precpuStats) :that.precpuStats != null) return false;
            if (read != null ? !read.equals(that.read) :that.read != null) return false;
            return true;
    }


    public class BlkioStatsNestedImpl<N> extends BlkioStatsFluentImpl<StatsFluent.BlkioStatsNested<N>> implements StatsFluent.BlkioStatsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatsBuilder builder;
    
            BlkioStatsNestedImpl(BlkioStats item){
                    this.builder = new BlkioStatsBuilder(this, item);
            }
            BlkioStatsNestedImpl(){
                    this.builder = new BlkioStatsBuilder(this);
            }
    
    public N and(){
            return (N) StatsFluentImpl.this.withBlkioStats(builder.build());
    }
    public N endBlkioStats(){
            return and();
    }

}
    public class CpuStatsNestedImpl<N> extends CPUStatsFluentImpl<StatsFluent.CpuStatsNested<N>> implements StatsFluent.CpuStatsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final CPUStatsBuilder builder;
    
            CpuStatsNestedImpl(CPUStats item){
                    this.builder = new CPUStatsBuilder(this, item);
            }
            CpuStatsNestedImpl(){
                    this.builder = new CPUStatsBuilder(this);
            }
    
    public N and(){
            return (N) StatsFluentImpl.this.withCpuStats(builder.build());
    }
    public N endCpuStats(){
            return and();
    }

}
    public class MemoryStatsNestedImpl<N> extends MemoryStatsFluentImpl<StatsFluent.MemoryStatsNested<N>> implements StatsFluent.MemoryStatsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final MemoryStatsBuilder builder;
    
            MemoryStatsNestedImpl(MemoryStats item){
                    this.builder = new MemoryStatsBuilder(this, item);
            }
            MemoryStatsNestedImpl(){
                    this.builder = new MemoryStatsBuilder(this);
            }
    
    public N and(){
            return (N) StatsFluentImpl.this.withMemoryStats(builder.build());
    }
    public N endMemoryStats(){
            return and();
    }

}
    public class PrecpuStatsNestedImpl<N> extends CPUStatsFluentImpl<StatsFluent.PrecpuStatsNested<N>> implements StatsFluent.PrecpuStatsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final CPUStatsBuilder builder;
    
            PrecpuStatsNestedImpl(CPUStats item){
                    this.builder = new CPUStatsBuilder(this, item);
            }
            PrecpuStatsNestedImpl(){
                    this.builder = new CPUStatsBuilder(this);
            }
    
    public N and(){
            return (N) StatsFluentImpl.this.withPrecpuStats(builder.build());
    }
    public N endPrecpuStats(){
            return and();
    }

}


}
